; Version 3.3
; Copyright 1999 by Henter-Joyce, Inc.
; 1/5/99. A.G. Added functions to speak format information along with text when reading
;   by lines, words and characters.
; 10/7/98. A.G. added scripts to toggle Braille grade two options.
; modified Braille panning scripts to use the new built-ins Braille prior and next line
; 7/1/98 A.G. Added FocusPointMovedEvent to be overridden by app specific script files.
; 5/18/98, A.G. added a default ReadWordInContext
; 4/27/98, A.G. added GraphicVerbosity script and AdjustJAWSVerbosity dialog
; 4/20/98, A.G modified FocusChangedEvent to handle focus changing from object to object
;  within the same window.
; SayFocusedObject was added.
; 4/13/98, A.G added RunJawsManager to load a JAWS utility from a list,
; as oppose to having separate keystrokes for each manager.
; 2/24/98, GG changes to allow text to be spoken as it is being unselected
; Added functions SelectingText and ProcessSelectText
; Modified functions NewTextEvent and all of the selection scripts
; SelectNextLine, select NextCharacter etc.
; 1/16/98, cw - Modified SayTaskBar to make use of new FindDescendantWindow
; script function.
; 1/19/98, cw - Made changes to ConfigManager, CreateDictionaryCommandLine,
; FrameManager, FrameManagerRun to add support for long filenames.

Include "hjglobal.jsh" ; default HJ global variables
Include "hjconst.jsh" ; default HJ constants
Include "default.jsm" ; message file
Include "magic.jsh"
Include "magcodes.jsh"
use "magic.jsb"

Const
;UT_OutputModes
  UT_SAYTYPEANDTEXT = 0,
  UT_FOCUS = 1,
  UT_CONTROLID = 2,
  UT_CLASS = 3,
  UT_TYPE = 4,
  UT_SUBTYPE = 5,
  UT_REALNAME = 6
Globals
  int SelectSet,
  int SelectFromX,
  int SelectFromY,
  Int Previous_Braille_Mode,
  String OldPcCursorDots,
  String OldJawsCursorDots,
  String OldInvisibleCursorDots,
  Int BrailleOldBlinkRate,
  Int BrailleOldBlinkRate2,
  Int BrailleCursorShape,
  Int BrailleStatusMode,
  Int BrailleGlobalPixelsPerSpace


Void Function AutoStartEvent ()
Let GlobalMousePixel = 3
FrameClearValues ()
if (DefaultFirstTime == 0) then
  let DefaultFirstTime = 1
  If (GetVerbosity() == BEGINNER) then
    If (!IsJFWInstall()) then
      Say (msg371, ot_help) ;"for screen sensitive help Press insert + f1"
      Say (msg372, ot_help) ;"for JAWS Help Keys or help in dialog boxes Press Insert + H"
      Say (msg373, ot_help) ;"for a summary of windows short cut keys Press insert + W"
    EndIf
  EndIf
EndIf ; DefaultFirstTime == 0
Let BrailleOldBlinkRate = GetDefaultJCFOption (optbrl_cursor_blink_rate)
Let BrailleCursorShape = 0
Let BrailleStatusMode = 0
let BackForward=0
EndFunction

Void Function AutoFinishEvent ()
;Put code here that will be triggered when the application is finished.
;It also gets performed when the application is switched from or looses focus, as with ALT+TAB.
EndFunction

Script  JawsWindow()
JawsWindow()
EndScript

Script StartJawsTaskList ()
; 12-11-98 - TGS - Added this script that basically just calls the built in of the same name.
; Bring up the Jaws Task List Dialog.  This function requires that JawsTaskList.dll be in the JFW directory
StartJawsTaskList()
EndScript

Script JawsEnd ()
JAWSEnd()
if IsPCCursor() then
  if (GetWindowTypeCode(GetCurrentWindow()) == WT_TABCONTROL ||
    GetWindowTypeCode(GetCurrentWindow()) == WT_SLIDER) then
delay(2)
    SayWord()
    return
  endif
endif
Say (msg1, ot_message) ;"End"
EndScript

Script JawsHome ()
JAWSHome()
if IsPCCursor() then
  if (GetWindowTypeCode(GetCurrentWindow()) == WT_TABCONTROL ||
    GetWindowTypeCode(GetCurrentWindow()) == WT_SLIDER) then
delay(2)
    SayWord()
    return
  endif
endif
Say (msg2, ot_message) ;"Home"
EndScript

Script SayPriorCharacter ()
; broke  or'ed conditions into separate if statements to gain speed, 03/03/96, GG
; added test for Tab Selection Controls, 03/03/96, GG
var
	int TheTypeCode,
	handle hCurrentWindow

PriorCharacter()
if ((IsLeftButtonDown()) || (IsRightButtonDown())) then
  SelectingText(TRUE)
  pause ()
  SelectingText(false)
  return
EndIf
if not IsPCCursor() then
  SayCharacter()
  return
endif
let hCurrentWindow = GetCurrentWindow()
if (GetWindowTypeCode(hCurrentWindow) == WT_TABCONTROL ||
 GetWindowTypeCode(hCurrentWindow) == WT_SLIDER) then
    SayWord()
    return
endif
if CaretVisible() then
  SayCharacter()
  Return
else
  let TheTypeCode = GetWindowSubTypeCode (hCurrentWindow)
  If (TheTypeCode == WT_MENU) then
    Say (msg3, ot_message) ;"Menu"
    SayWindow (hCurrentWindow, READ_HIGHLIGHTED)
    return
  EndIf
  if (TheTypeCode == WT_STARTMENU) then
    SayWindow (hCurrentWindow, READ_HIGHLIGHTED)
    If (MagGetState () > 0)then
      TrackStartMenu(hCurrentWindow)
    endif
    return
  EndIf
  if (TheTypeCode == WT_CONTEXTMENU) then
    Say (msg5, ot_message) ;"Context Menu"
    SayWindow (hCurrentWindow, READ_HIGHLIGHTED)
    return
  EndIf
	If (TheTypeCode == WT_TREEVIEW) Then
		SayTreeViewLevel ()
	Endif
EndIf
EndScript

Script SayNextCharacter ()
; broke  or'ed conditions into separate if statements to gain speed, 03/03/96, GG
; added test for Tab Selection Controls, 03/03/96, GG
var
	int TheTypeCode,
	handle hCurrentWindow

NextCharacter()
if ((IsLeftButtonDown()) || (IsRightButtonDown())) then
  SelectingText(TRUE)
  pause ()
  SelectingText(false)
  return
EndIf
if not IsPCCursor() then
  SayCharacter()
  return
endif
let hCurrentWindow = GetCurrentWindow()
if (GetWindowTypeCode(hCurrentWindow) == WT_TABCONTROL ||
  GetWindowTypeCode(hCurrentWindow) == WT_SLIDER) then
    SayWord()
    return
endif
if CaretVisible() then
  SayCharacter()
  Return
else
  let TheTypeCode = GetWindowSubTypeCode (hCurrentWindow)
  If (TheTypeCode == WT_MENU) then
    Say (msg3, ot_message) ;"Menu"
    SayWindow (hCurrentWindow, READ_HIGHLIGHTED)
    return
  EndIf
  if (TheTypeCode == WT_STARTMENU) then
    SayWindow (hCurrentWindow, READ_HIGHLIGHTED)
    If (MagGetState () > 0)then
      TrackStartMenu(hCurrentWindow)
    endif
    return
  EndIf
  if (TheTypeCode == WT_CONTEXTMENU) then
    Say (msg5, ot_message) ;"Context Menu"
    SayWindow (hCurrentWindow, READ_HIGHLIGHTED)
    return
  EndIf
	If (TheTypeCode == WT_TREEVIEW) Then
		SayTreeViewLevel ()
	Endif
EndIf
EndScript

Script SayPriorLine ()
var; broke  or'ed conditions into separate if statements to gain speed, 03/03/96, GG
; added test for Tab Selection Controls, 03/03/96, GG
	String TheWindowName,
	int TheTypeCode
Let theWindowName=GetWindowName (GetAppMainWindow (GetFocus ()))
PriorLine()
if (IsLeftButtonDown ()) then
  SelectingText(TRUE)
  pause ()
  SelectingText(false)
  return
EndIf
if not IsPCCursor () then
  SayLine()
  return
endif
if (GetWindowTypeCode (GetCurrentWindow ()) == WT_SLIDER) then
  SayWord ()
  return
EndIf
if (GetWindowTypeCode (GetCurrentWindow ()) == WT_TABCONTROL) then
  SayWord()
  return
EndIf
if CaretVisible() then
  SayLine()
  return
EndIf
let TheTypeCode = GetWindowSubtypeCode (GetCurrentWindow ())
If ((TheTypeCode == WT_MULTISELECT_LISTBOX) ||
   (TheTypeCode == WT_EXTENDEDSELECT_LISTBOX)) then
    SayLine()
EndIf
If TheTypeCode==WT_TreeView
Then SayTreeViewLevel()
endif
EndScript

Script SayNextLine()
var; broke  or'ed conditions into separate if statements to gain speed, 03/03/96, GG
; added test for Tab Selection Controls, 03/03/96, GG
	String TheWindowName,
	int TheTypeCode
Let theWindowName=GetWindowName (GetAppMainWindow (GetFocus ()))
NextLine()
if (IsLeftButtonDown ()) then
  SelectingText(TRUE)
  pause ()
  SelectingText(false)
  return
EndIf
if  not IsPCCursor () then
  SayLine ()
  return
EndIf
if (GetWindowTypeCode (GetCurrentWindow ()) == WT_SLIDER) then
  SayWord ()
  return
EndIf
if (GetWindowTypeCode(GetCurrentWindow()) == WT_TABCONTROL) then
  SayWord()
  return
EndIf
if CaretVisible () then
  SayLine ()
  return
EndIf
let TheTypeCode = GetWindowSubtypeCode (GetCurrentWindow())
If ((TheTypeCode == WT_MULTISELECT_LISTBOX) ||
   (TheTypeCode == WT_EXTENDEDSELECT_LISTBOX)) then
     SayLine()
endif
If TheTypeCode==WT_TreeView
Then SayTreeViewLevel()
endif
EndScript

Script ControlUpArrow ()
var
	int TheTypeCode,
	int MenuMode
Let MenuMode =  GlobalMenuMode
Let TheTypeCode = GetWindowSubTypeCode (GetCurrentWindow())
if IsJAWSCursor () ||
IsVirtualPCCursor ()
 then PerformScript SayPriorParagraph()
return
endif
if DialogActive () ||
 ((TheTypeCode == WT_TREEVIEW) ||
   (TheTypeCode == 	WT_EDITCOMBO) ||
(TheTypeCode == WT_Listbox) ||
   (TheTypeCode == WT_LISTVIEW) ||
(TheTypeCode == WT_Combobox) ||
   (TheTypeCode == WT_MULTISELECT_LISTBOX) ||
   (TheTypeCode == WT_EXTENDEDSELECT_LISTBOX))||
 GetWindowClass (GetCurrentWindow ())==wcMsoCmd
 then
     {control + up arrow} ; move without removing selection
     pause ()
     SayLine()
     return
endif
if (GetWindowTypeCode(GetCurrentWindow()) == WT_TABCONTROL) then
  SayWord()
  return
endif
if (MenuMode > 0) then return
 EndIf
PerformScript SayPriorParagraph()
EndScript

Script ControlDownArrow ()
var
	int MenuMode,
	int TheTypeCode
Let MenuMode =  GlobalMenuMode
Let TheTypeCode = GetWindowSubTypeCode (GetCurrentWindow())
if IsJAWSCursor () ||
IsVirtualPCCursor ()
 then PerformScript SayNextParagraph()
return
endif
if  DialogActive () ||
 ((TheTypeCode == WT_TREEVIEW) ||
   (TheTypeCode == WT_LISTVIEW) ||
   (TheTypeCode == 	WT_EDITCOMBO) ||
   (TheTypeCode == WT_Listbox) ||
   (TheTypeCode == WT_Combobox) ||
   (TheTypeCode == WT_MULTISELECT_LISTBOX) ||
   (TheTypeCode == WT_EXTENDEDSELECT_LISTBOX)) ||
GetWindowClass (GetCurrentWindow ())==wcMsoCmd
 then   {control + down arrow} ; move without removing selection
     pause ()
     SayLine()
     return
endif
if (GetWindowTypeCode(GetCurrentWindow()) == WT_TABCONTROL) then
  {control + down arrow}
  SayWord()
  return
endif
if (MenuMode > 0) then {control + down arrow}
return
EndIf
 PerformScript SayNextParagraph()
		EndScript
Script  JawsPageDown()
JAWSPageDown()
if IsVirtualPCCursor ()
then Say (msg6, ot_message) ;"Page down"
SayLine ()
return
endif
if IsPCCursor() then
  if (GetWindowTypeCode(GetCurrentWindow()) == WT_TABCONTROL ||
   GetWindowTypeCode(GetCurrentWindow()) == WT_SLIDER) then
delay(2)
     SayWord()
     return
  endif
endif
Say (msg6, ot_message) ;"Page down"
EndScript

Script  JawsPageUp()
JAWSPageUp()
if IsVirtualPCCursor ()
then Say (msg7, ot_message) ;"Page up"
SayLine ()
return 
endif
if IsPCCursor() then
  If (GetWindowTypeCode(GetCurrentWindow()) == WT_TABCONTROL ||
   GetWindowTypeCode(GetCurrentWindow()) == WT_SLIDER) then
delay(2)
     SayWord()
     return
  endif
endif
Say (msg7, ot_message) ;"Page up"
EndScript

Script PCCursor ()
ResetSynth ()
PCCursor ()
If IsVirtualPCCursor () 
then Say (msg563, ot_message)
IEUpdate()
return
else  Say (msg10, ot_message) ; "PC Cursor"
endif
if BrailleInUse () then
  RouteBrailleToPC ()
EndIf
if IsPCCursor ()
then IEUpdate ()
endif
EndScript

Script  JawsCursor ()
var 
int WasVirtual
let WasVirtual=0
ResetSynth ()
if  IsVirtualPCCursor ()
then SetJCFOption (	OPT_VIRTUAL_PC_CURSOR, 0)
let WasVirtual=1
endif
if (IsSameScript ()) then
  InvisibleCursor()
  Say (msg11, ot_message) ;"invisible Cursor"
else
  JAWSCursor ()
  Say (msg13, ot_message) ;"JAWS Cursor"
  if BrailleInUse () then
    RouteBrailleToJaws ()
  EndIf
EndIf
if WasVirtual==1
then SetJCFOption (	OPT_VIRTUAL_PC_CURSOR, 1)
endif
EndScript

Void Function SetActiveCursor (int nCursor)
if (nCursor == CURSOR_JAWS) then JAWSCursor ()
elif (nCursor == CURSOR_INVISIBLE) then InvisibleCursor()
else PcCursor () endif
EndFunction

Script  GraphicsLabeler()
if !IsPCCursor () 
then SaveCursor ()
PCCursor ()
GraphicsLabeler()
RestoreCursor ()
return
else
GraphicsLabeler()
endif
EndScript

Script SayDriveLetter ()
var
	int x
let x=0
InvisibleCursor ()
RouteInvisibleToPc ()
while ((GetCharacter () != "(")	&& (x<5))
  NextWord ()
  let x=x+1
endwhile
if (x != 5) then NextCharacter () SayCharacter () endif
PcCursor ()
EndScript

Script  SaySpecialWindowClasses()
var
	handle WinHandle
If (GetCurrentWindow ()) then ;window handle is not 0
  if (TimesPressedDefault < 4) then
    let TimesPressedDefault = TimesPressedDefault + 1
  else
    let TimesPressedDefault = 1 ; reset it
  endif ; if times Pressed
  if TimesPressedDefault == 1 then
    let WinHandle = GetCurrentWindow ()
    while (WinHandle) ; loop until 0
      Say (msg20, ot_message) ;"Parents class ="
      Say (GetWindowClass (GetParent (WinHandle)), ot_window_information)
      SpellString (GetWindowClass (GetParent (WinHandle)))
      let WinHandle = GetParent (WinHandle)
    EndWhile
    return
  endif ; times pressed =1
  if (TimesPressedDefault == 2) then
    Say (msg21, ot_message) ;"Prior window class ="
    Say (GetWindowClass (GetPriorWindow (GetCurrentWindow ())), ot_window_information)
    SpellString (GetWindowClass (GetPriorWindow (GetCurrentWindow ())))
    return
  endif ; times pressed = 2
  if (TimesPressedDefault == 3) then
    Say (msg22, ot_message) ;"next window class ="
    Say (GetWindowClass (GetNextWindow (GetCurrentWindow ())), ot_window_information)
    SpellString (GetWindowClass (GetNextWindow (GetCurrentWindow ())))
    return
  endif ; times pressed = 3
  if (TimesPressedDefault == 4) then
    Say (msg23, ot_message) ;"first child window class ="
    Say (GetWindowClass (GetFirstChild (GetCurrentWindow ())), ot_window_information)
    SpellString (GetWindowClass (GetFirstChild (GetCurrentWindow ())))
    return
  endif ; times pressed = 4
else ; handle = 0
  Say (msg24, ot_message) ;"the window handle is 0"
  Say (msg25, ot_message) ;"This may be an item that is minimized "
  Say (msg26, ot_message) ;"press the enter key or click the mouse button to open it"
EndIf
EndScript

Script  JawsBackspace()
var
	int TheTypeCode
SaveCursor ()
PCCursor ()
let TheTypeCode = GetWindowSubtypeCode (GetCurrentWindow())
If ((TheTypeCode == WT_TREEVIEW) || (TheTypeCode == WT_LISTVIEW)) then
  {backspace}
else
  RouteInvisibleToPc ()
  InvisibleCursor ()
  PriorCharacter ()
  SayCharacter ()
  {backspace}
endif
RestoreCursor ()
EndScript

Script JawsDelete()
var
	int TheTypeCode
SaveCursor ()
PCCursor ()
let TheTypeCode = GetWindowSubtypeCode (GetCurrentWindow())
{delete}
if ((TheTypeCode == WT_LISTBOX) ||
   (TheTypeCode == WT_LISTVIEW) ||
   (TheTypeCode == WT_TREEVIEW)) then
     return
EndIf
delay (1)
SayCharacter()
RestoreCursor ()
EndScript

Script  RestrictJawsCursor()
if ToggleRestriction() then
	Say (msg27, ot_message) ;"Restriction on Jaws Cursor"
else
	Say (msg28, ot_message) ;"restriction off Jaws Cursor"
endif
EndScript

Script  ShutDownJAWS()
Say (msg29, ot_message) ;"Unloading JAWS"
ShutDownJAWS()
EndScript

Script SayWindowTitle()
var
	handle CurrentWindow,
	handle RealWindow,
	handle AppWindow,
	int TheTypeCode
let CurrentWindow = GetCurrentWindow()
if (CurrentWindow > 0) then ; handle not 0
  let RealWindow = GetRealWindow (CurrentWindow)
  let AppWindow = GetAppMainWindow (CurrentWindow)
  let TheTypeCode = GetWindowSubTypeCode (GetCurrentWindow())
  if GetVerbosity() == 0 then Say (msg30, ot_message) EndIf  ;"Title ="
  if (IsMultiPageDialog ()) then
    Say (GetWindowName (RealWindow), ot_window_name)
    Say (msg31, ot_message) ;"page is"
    Say (GetDialogPageName (), ot_window_information)
    return
  endif
  If (TheTypeCode == WT_STARTBUTTON) then Say (msg32, ot_message) Return endif  ;"Start Button"
  If (TheTypeCode == WT_STARTMENU) then
    Say (msg4, ot_message) ;"Start Menu"
    SayWindow (GetCurrentWindow (), READ_HIGHLIGHTED)
    Return
  EndIf
  If (TheTypeCode == WT_MENU) then
    Say (msg3, ot_message)	 ;"Menu"
    SayWindow (GetCurrentWindow (), READ_HIGHLIGHTED)
    Return
  EndIf
  If (TheTypeCode == WT_TASKBAR) then Say (msg33, ot_message) EndIf  ;"TaskBar"
  If AppWindow != CurrentWindow then Say (GetWindowName (AppWindow), ot_window_name) endif
  If ((RealWindow != AppWindow) && (RealWindow != CurrentWindow)) then
    Say (GetWindowName (RealWindow), ot_window_name)
  endif
  ;now say the current window
  Say (GetWindowName (CurrentWindow), ot_window_name)
else
  ScreenSensitiveHelpForUnknownClasses()  ; when handle =0
endif
EndScript

Script NextDocumentWindow()
{control+tab}
delay (1)
if (IsMultiPageDialog ()) then
  Say (GetDialogPageName (), ot_dialog_information)
  return
endif
EndScript

Script PreviousDocumentWindow()
{control+shift+tab}
Delay (1)
if (IsMultiPageDialog ()) then
  Say (GetDialogPageName (), ot_dialog_information)
  return
endif
EndScript

Script ReadBoxInTabOrder()
;Reads thru Dialog Box in Tab order
var
	int safety,
	handle winhandle
let safety = 0
; figure out if we're in a dialog box
let winhandle = GetRealWindow(GetCurrentWindow())
if (GetWindowTypeCode (winhandle )== WT_DIALOG) then
  if GetVerbosity() == 0 then
    Say (msg34, ot_message);"Reed Box in tab order "
  EndIf
    Say (GetWindowName (winhandle), ot_window_name)
  ; work our way through all child windows of the dialog
  if (IsMultiPageDialog ()) then
    let winhandle = GetFocus()
    while ((GetPriorWindow (winhandle)) && (Safety < 100))
      let winhandle = GetPriorWindow (winhandle)
      let Safety = Safety + 1
    endwhile
    while (IsWindowVisible (winhandle) == FALSE)
      let winhandle = GetNextWindow (winhandle)
    endwhile
  else
    let winhandle   = GetFirstChild (winhandle)
  endif
  while (winhandle)
    SayControl (winhandle)
    let winhandle = GetNextWindow (winhandle)
  EndWhile
Elif GetVerbosity() == 0 then
  Say (msg35, ot_message) ;"Not a dialog box"
  Say (msg35a, ot_message) ;"application window equals"
  SayWindow (GetRealWindow (GetCurrentWindow ()), 0)
else
  SayWindow (GetRealWindow (GetCurrentWindow ()), 0)
endif
EndScript

Void Function ItemNotFoundEvent (int hwnd)
; event indicating that the requested item can't be found in the OSM
beep()
EndFunction

Void Function KeyPressedEvent (int nKey, string strKeyName, int nIsBrailleKey, int nIsScriptKey)
; Add your code for KeyPressedEvent here.
; Changes made here apply to all applications.
; To make your changes application specific, copy this function to an
; application script file.
; SayInteger (nkey)
if NKey==57
then  if GetWindowSubTypeCode (GetFocus ())==20 
then 
Delay(3)
 if (ControlIsChecked ()) then
Say (msg589, ot_string)
 else
Say (msg590, ot_string)
 endif
;  else
; Say (msgnull, ot_string)
; endif
endif
endif
EndFunction

Void Function FocusPointMovedEvent (int nX, int nY, int nOldX, int nOldY, int nUnit, int nDir, int nTimeElapsed)
; Add your code for FocusPointMovedEvent here.
; Changes made here apply to all applications.

; To make your changes application specific, copy this function to an
; application script file.
EndFunction

Void Function NewTextEvent (handle hwnd, string buffer, int nAttributes,
int nTextColor, int nBackgroundColor, int nEcho, string sFrameName)
; Handles all newly written text.  If the text is contained in a
; frame, then the frame name is passed as a parameter
if (ProcessSelectText(nAttributes,buffer)) then
  return
endif
if (sFrameName == msgNull) then
  ; this text is not associated with a frame
  if (nAttributes& ATTRIB_HIGHLIGHT) then SayHighlightedText(hwnd,buffer)
  else SayNonHighlightedText(hwnd,buffer) endif
else
  ; this text is associated with a frame
  if (nEcho == ECHO_NONE) then return endif  ; frame is being silenced
  if (nEcho  == ECHO_ALL || (nAttributes & ATTRIB_HIGHLIGHT)) then
  ; if FrameEcho is set to all or the text being written is highlighted
    Say (buffer, ot_buffer)
  endif
endif
EndFunction

Void Function SayHighLightedText (handle hwnd, string buffer)
; HighlightedText Function for speaking all newly written highlighted
; text.
	if (GetWindowSubTypeCode (hwnd) == WT_TREEVIEW) Then
		SayTreeViewLevel ()
		Return
	EndIf
if (GetScreenEcho() > 0) then Say (buffer, ot_buffer) EndIf
EndFunction

Void Function SayNonHighlightedText (handle hwnd, string buffer)
; NonHighlightedText  Function for speaking all newly written nonhighlighted
; text.
; Commented code added 09/24/99 by DB
; for use with Dos Boxes and Console apps
var
	string TheClass
let TheClass = GetWindowClass(hwnd)
; for Windows 95, 98 and/or NT
; Just remove the c-style /* */ comments around this block of code
; if you wish Jaws to speak automatically in Dos Windows
; for text output, such as command prompt or command-line apps such as FTP and Ping
/*
If (TheClass == "tty" || TheClass == "ttygrab" || TheClass == "ConsoleWindowClass") then
	Say (buffer, OT_BUFFER);
	Return
EndIf
*/
;wn36="#32771"
if ((GetScreenEcho() > 1) || (TheClass == wn36 )) then Say (buffer, ot_buffer) EndIf
EndFunction

Function SelectingText(int nMode)
; handles seting up for and finishing the process of selecting text
; called by each of the scripts which does text selection
if (nMode) then let nSelectingText = nMode
else Delay(1) ProcessNewText() let nSelectingText = 0 endif
EndFunction

Function ProcessSelectText(int nAttributes,string buffer)
; called at the beginning of the NewTextEvent to check for and
; handle speaking of text being  selected/unselected.  If this function
; returns TRUE, then the NewTextEvent abandons regular processing.
if (nSelectingText == 0) then
  if (nAttributes & ATTRIB_UNSELECTED) then
  ; only relevant when text is being selected/unselected
  ; return TRUE to indicate that this text requires no further handling
    return  TRUE
  else
    return false ; allow regular processing
  endif
endif
if (nAttributes & ATTRIB_HIGHLIGHT|| nAttributes & ATTRIB_UNSELECTED) then
  if ((nAttributes & ATTRIB_UNSELECTED) && (nSelectingText != 2)) then
    let nSelectingText = 2
    Say (msg478, ot_message) ; "Unselect "
  elif ((nAttributes & ATTRIB_HIGHLIGHT) && (nSelectingText != 4)) then
    let nSelectingText = 4
    Say (msg479, ot_message) ; select
  endif
  Say(buffer, OT_CHAR)
  return true
else
  return FALSE
endif
EndFunction

Script TopOfFile()
JAWSTopOfFile()
delay (1)
if IsVirtualPCCursor ()
then SayLine ()
endif
If(GetVerbosity() == 0) Then
  Say (msg37, ot_message) ;"top of file"
  PCCursor()
  SayLine()
EndIf
EndScript

Script BottomOfFile()
JAWSBottomOfFile()
Delay (1)
if IsVirtualPCCursor ()
then SayLine ()
endif
If(GetVerbosity() == 0) Then
  Say (msg38, ot_message) ;"Bottom of file"
  PCCursor()
  SayLine()
EndIf
EndScript

Script SayFont ()
; Identify Font
if GetVerbosity() == 0 then Say (msg39, ot_message) EndIf  ;"Font equals"
SayFont()
EndScript

Script SaySelectedText()
; Read all selected text
If(GetVerbosity() == 0) Then Say (msg40, ot_message) EndIf  ;"Selected text is"
if (IsVirtualPCCursor()) then
Say (GetSelectedText(), ot_message)
else
SayWindow(GetCurrentWindow(),1) ; say the highlighted text only
Endif
EndScript

; **/1 Start of Selecting Text
Script SelectToEndOfLine()
SelectingText(TRUE)
SelectToEndOfLine ()
SelectingText(FALSE)
EndScript

Script SelectFromStartOfLine()
SelectingText(TRUE)
SelectFromStartOfLine ()
SelectingText(FALSE)
EndScript

Script SelectNextLine()
SelectingText(TRUE)
SelectNextLine ()
SelectingText(FALSE)
EndScript

Script SelectPriorLine()
SelectingText(TRUE)
SelectPriorLine ()
SelectingText(FALSE)
EndScript

Script SelectNextCharacter()
SelectingText(TRUE)
SelectNextCharacter ()
SelectingText(FALSE)
EndScript

Script SelectPriorCharacter()
SelectingText(TRUE)
SelectPriorCharacter ()
SelectingText(FALSE)
EndScript

Script SelectNextWord()
SelectingText(TRUE)
SelectNextWord ()
SelectingText(FALSE)
EndScript

Script SelectPriorWord()
SelectingText(TRUE)
SelectPriorWord ()
SelectingText(FALSE)
EndScript

Script SelectNextScreen()
SelectingText(TRUE)
SelectNextScreen ()
SelectingText(FALSE)
EndScript

Script  SelectPriorScreen()
SelectingText(TRUE)
SelectPriorScreen ()
SelectingText(FALSE)
EndScript

Script  SelectToBottom()
SelectingText(TRUE)
SelectToBottom ()
SelectingText(FALSE)
EndScript

Script  SelectFromTop()
SelectingText(TRUE)
SelectFromTop ()
SelectingText(FALSE)
EndScript

; **/2 End of Selecting Text Scripts

Script CloseDocumentWindow()
{Control+F4}
if GetVerbosity() == 0 then Say (msg47, ot_message) EndIf  ;"Close Document Window"
EndScript

Script OpenListBox ()
var int TheTypeCode, int nMagAltMode
;nMagAltMode < 0 ;Magic not running
;nMagAltMode = 0 ;Shift arrow keys used for manual panning
;nMagAltMode = 1 ;Alt arrow keys used for manual panning
Let TheTypeCode = GetWindowSubTypeCode (GetCurrentWindow())
;If MAGic is running and Manual panning is on the alt keys
if (MagGetState () > 0) then
	Let nMagAltMode = MagGetOption (MPK_ALT)
	if (nMagAltMode == 1) then
		;The screen is magnified
		Say (mag006 /*down*/, OT_STRING)
		{Alt+Down Arrow}
		return
	endif
endif
if IsJAWSCursor () ||
IsVirtualPCCursor ()
 then PerformScript SayNextSentence()
return
endif
if  DialogActive () ||
 ((TheTypeCode == WT_TREEVIEW) ||
   (TheTypeCode == WT_Listview) ||
   (TheTypeCode == 	WT_EDITCOMBO) ||
(TheTypeCode == WT_Listbox) ||
   (TheTypeCode == WT_MULTISELECT_LISTBOX) ||
   (TheTypeCode == WT_EXTENDEDSELECT_LISTBOX))  ||
(TheTypeCode == WT_Combobox) ||
GetWindowClass (GetCurrentWindow ())==wcMsoCmd
then {Alt+Down Arrow}
Say (msg48, ot_message)
return
endif
PerformScript SayNextSentence()
EndScript

Script CloseListBox()
var	int TheTypeCode,	int nMagAltMode
;nMagAltMode < 0 ;Magic not running
;nMagAltMode = 0 ;Shift arrow keys used for manual panning
;nMagAltMode = 1 ;Alt arrow keys used for manual panning
Let TheTypeCode = GetWindowSubTypeCode (GetCurrentWindow())
if (MagGetState () > 0) then
	;If MAGic is running and Manual panning is on the alt keys
	Let nMagAltMode = MagGetOption (MPK_ALT)
	if (nMagAltMode == 1) then
		;The screen is magnified
		Say (mag005 /*UP*/, OT_STRING)
		{Alt+Up Arrow}
		return
	EndIf
EndIf
if IsJAWSCursor () ||
IsVirtualPCCursor ()
 then PerformScript SayPriorSentence()
return
endif
if  DialogActive () ||
 ((TheTypeCode == WT_TREEVIEW) ||
   (TheTypeCode == 	WT_EDITCOMBO) ||
(TheTypeCode == WT_Listbox) ||
   (TheTypeCode == WT_LISTVIEW) ||
   (TheTypeCode == WT_MULTISELECT_LISTBOX) ||
   (TheTypeCode == WT_EXTENDEDSELECT_LISTBOX))  ||
(TheTypeCode == WT_Combobox) ||
GetWindowClass (GetCurrentWindow ())==wcMsoCmd
then {Alt+up Arrow}
Say (msg48b, ot_message)
return
endif
PerformScript SayPriorSentence()
EndScript

Script SelectAllItems()
{Control+Slash}
if GetVerbosity() == 0 then Say (msg49, ot_message) EndIf  ;"Select All"
EndScript

Script UnselectAllButCurrent()
{Control+\}
; msg50 = "Cancel All Selections in a List Except for the Current Selection"
if GetVerbosity() == 0 then Say (msg50, ot_message) EndIf
EndScript

Script SelectAll ()
SelectEntireDocument()
EndScript

Script  PassKeyThrough()
;msg51 = "Enter key to pass thru"
if GetVerbosity() == 0 then Say (msg51, ot_message) EndIf
PassKeyThrough()
EndScript

Function TopEdgeEvent (handle WindowHandle)
Var
	int Verbosity
let Verbosity = GetVerbosity ()
if Verbosity == 0 then
  Beep ()
  Beep ()
  Say (msg52, ot_message) ;"Top of window"
  Return
endif
if Verbosity == 1 then
  Beep ()
  Beep ()
  Say (msg53, ot_message) ;"Top "
  Return
endif
if Verbosity == 2 then
  Beep ()
  Beep ()
  Return
endif
EndFunction

Function BottomEdgeEvent (handle WinHandle)
Var
	int Verbosity
let Verbosity = GetVerbosity ()
if Verbosity == 0 then
  Beep ()
  Beep ()
  Say (msg54, ot_message) ;"Bottom of Window"
  Return
endif
if Verbosity == 1 then
  Beep ()
  Beep ()
  Say (msg55, ot_message) ;"Bottom"
  Return
endif
if Verbosity == 2 then
  Beep ()
  Beep ()
  Return
endif
EndFunction

Function FocusChangedEvent (handle FocusWindow, handle PrevWindow)
var
	handle RealWindow,
	string RealWindowName,
	handle AppWindow
let RealWindow = GetRealWindow (FocusWindow)
let RealWindowName = GetWindowName (RealWindow)
let AppWindow = GetAppMainWindow (FocusWindow)
if (GlobalPrevApp != AppWindow && AppWindow != FocusWindow) then
  ; we've switched to a different app main window,
  ; and it does not have the focus, so announce it
  SayWindowTypeAndText (AppWindow)
endif
If ((GlobalPrevRealName != RealWindowName) ; name has changed
  || (GlobalPrevReal != RealWindow)) then ; or handle has changed, then
  If ((RealWindow != AppWindow) && (RealWindow != FocusWindow)) then
    SayWindowTypeAndText (RealWindow)
  endif
EndIf
let GlobalFocusWindow = FocusWindow
if (GlobalPrevFocus != focusWindow) then
  SayFocusedWindow () ; will use global variable GlobalFocusWindow
else
  SayFocusedObject ()
EndIf
;above perform will return here to finish this routine
;now set all the global variables for next time.
let GlobalPrevReal = RealWindow
let GlobalPrevRealName = RealWindowName
let GlobalPrevApp = AppWindow
let GlobalPrevFocus = FocusWindow
EndFunction

Function ActiveItemChangedEvent (handle curHwnd, int curObjectId, int curChildId,
handle prevHwnd, int prevObjectId, int prevChildId)
SaveCursor ()
PCCursor ()
SayObjectActiveItem()
RestoreCursor ()
EndFunction

Void Function ValueChangedEvent (handle hwnd, int objId, int childId, int nObjType, string sObjName, string sObjValue)
; Enter code here for Application-Specific script files
;to act upon the change of value of the MSAA object
EndFunction

Void Function DocumentLoadedEvent ()
var
int nFrames,
int nLinks,
string Buffer
IEUpdate()
if BackForward==1
then SayLine()
let BackForward=0
return
endif
if GetWindowClass (GetFocus ())==wcIEServer then
PCCursor()
if  (IsVirtualPCCursor()) then
let nFrames = GetHTMLFrameCount()
let buffer = msgPageHas
if (nFrames > 0) then
let buffer = buffer + IntToString(nFrames)+ msgFramesAnd
EndIf
let nLinks = GetLinkCount()
if NLinks==1 then
 let buffer = buffer+IntToString(nLinks)+ msgLink
else let buffer = buffer+IntToString(nLinks)+ msgLinks
endif 
Say (Buffer, OT_STRING)
SayAll()
Endif
endif
EndFunction
void function FormsModeEvent(int bEntering)
if (bEntering) then
Say (msg561, OT_STRING)
else
Say (msg562, OT_STRING)
EndIf
EndFunction
function TextSelectedEvent(string strText, int bUnSelecting)
if (bUnSelecting) then
Say (msgUnselecting, OT_STRING)
else
Say (msgSelecting, OT_STRING)
EndIf
Say (strText, OT_STRING)
EndFunction

Void Function SayFocusedWindow ()
SayWindowTypeAndText (GlobalFocusWindow)
EndFunction

Function SayFocusedObject ()
SaveCursor ()
PCCursor ()
SayObjectTypeAndText ()
RestoreCursor ()
EndFunction

Function MenuModeEvent (handle WinHandle, int mode)
;The Mode parameter indicates whether the menuBar has become active, a
;Menu  has become active, or the menus are going away.  These are
;represented by the constants MENUBAR_ACTIVE, MENU_ACTIVE, and
;MENU_INACTIVE.
Var
	int Verbosity,
	handle FocusWindow,
	handle RealWindow,
	string RealWindowName,
	handle AppWindow,
	int PrevMenuMode,
	int TheTypeCode
Let TheTypeCode = GetWindowSubTypeCode (GetCurrentWindow())
let PrevMenuMode = GlobalMenuMode
let GlobalPrevMenuMode = PrevMenuMode
let GlobalMenuMode=mode
let Verbosity = GetVerbosity ()
if Verbosity == beginner then
  if (mode == MENU_INACTIVE) then
    If (PrevMenuMode == MENUBAR_ACTIVE) then
      Say (msg58, ot_message) ;"leaving menu bar"
    else
       Say (msg59, ot_message) ;"Leaving menus"
    endif
    return
  endif ; menu inactive
  if (TheTypeCode == WT_CONTEXTMENU) then
    Say(msg5, ot_message) ;"Context Menu"
    {down arrow}; 95, say first item in menu
    MenuModeHook ()
    return
  EndIf
  if (mode == MENUBAR_ACTIVE) then
    Say (msg56, ot_message) ;"	Menu bar"
    MenuModeHook ()
    return
  endif ; menu bar active
  if (mode == MENU_ACTIVE) then
    if GetWindowSubTypeCode(WinHandle) == WT_STARTMENU then
      Say(msg4,ot_message) ;"Start Menu"
      {down arrow} ; 95, say first item in menu
    else
      Say (msg57, ot_message) ;"Menu active"
    endif ; if start menu
    MenuModeHook ()
    return
  endif ; menu active
endif ; verbosity beginer
if Verbosity != beginner then
  if (TheTypeCode == WT_CONTEXTMENU) then
    {down arrow}; 95, say first item in menu
    MenuModeHook ()
    return
  EndIf
  if (mode == MENU_ACTIVE) then
    if GetWindowSubTypeCode(WinHandle) == WT_STARTMENU then
      {down arrow} ; 95, say first item in menu
    endif ; if start menu
    MenuModeHook ()
    return
  else
    Pause()
    MenuModeHook ()
    return
  endif ; menu active
endif ; verbosity advanced
let FocusWindow = GetFocus()
If (FocusWindow == GlobalPrevFocus) then
  let RealWindow = GetRealWindow(FocusWindow)
  let RealWindowName = GetWindowName (RealWindow)
  let AppWindow = GetAppMainWindow(FocusWindow)
  if ((verbosity == beginner) && (RealWindow != FocusWindow)) then
    SayWindowTypeAndText(RealWindow)
  endif ; verbosity beginner
  ;no matter what, say the window with focus
  SayWindowTypeAndText(FocusWindow)
EndIf ; focus window = global prev focus
MenuModeHook()
EndFunction

Function MenuModeHook ()
; This Script can be added to application Script files to add onto menu mode.
EndFunction

;**/3 start of cut/paste Scripts
Script Undo()
{Control+z}
if GetVerbosity() == 0 then
  Say (msg60, ot_message) ;"Undo"
EndIf
EndScript

Script CutToClipboard()
{Control+X}
if GetVerbosity() == 0 then
  Say (msg61, ot_message) ;"Cut Selected to clipboard"
  Return
EndIf
if GetVerbosity() == 1 then
  Say (msg62, ot_message) ;"cut text"
EndIf
EndScript

Script CopySelectedTextToClipboard ()
CopySelectionToClipboard()
if GetVerbosity() == 0 then
  Say (msg63, ot_message) ;"Copied selected text to clipboard"
  return
EndIf
if GetVerbosity() == 1 then
  Say (msg64, ot_message) ;"Copied text"
EndIf
EndScript

Script PasteFromClipboard()
{Control+V}
if GetVerbosity() == 0 then
  Say (msg65, ot_message) ;"Pasted text from clipboard"
  Return
EndIf
if GetVerbosity() == 1 then
  Say (msg66, ot_message) ;"Pasted text"
EndIf
EndScript

; **/4 End of cut and paste scripts

Script RefreshScreen ()
;Used to refresh the screen
Refresh ()
;msg67 = "Screen Refreshed"
if IsVirtualPCCursor ()
then Say (msg565, ot_string)
return
endif
if GetVerbosity() == 0 then Say (msg67, ot_message) EndIf
;msg68 = "Refreshed"
if GetVerbosity() == 1 then Say (msg68, ot_message) EndIf
EndScript

Int Function IsPointInWindow (handle hwnd, int x, int y)
var
	int top,
	int left,
	int bottom,
	int right
let top = GetWindowTop (hwnd)
let left = GetWindowLeft (hwnd)
let bottom = GetWindowBottom (hwnd)
let right = GetWindowRight (hwnd)
if (left <= x && x <= right && top <= y && y <= bottom) then  return true
else return false EndIf
EndFunction

Script ReadWordInContext ()
; read word in context, for spell check, find, replace, etc.
var
	handle appWindow,
	handle realWindow,
	handle focusedWindow,
 	int c
let focusedWindow = GetFocus ()
let RealWindow = GetRealWindow (focusedWindow)
let appWindow = GetAppMainWindow (focusedWindow)
SaveCursor ()
JAWSCursor ()
; try to find the highlighted word starting at the top of the window
MoveToWindow (appWindow)
let c = 0;
while (FindNextAttribute (attrib_highlight) && (c < 10))
  if (!IsPointInWindow (realWindow, GetCursorCol (), GetCursorRow ()) && (GetCurrentWindow () != appWindow)) then
    SayLine ()
    RestoreCursor ()
    return
  EndIf
  let c = c + 1
EndWhile
MoveTo (GetWindowRight (appWindow) - 3, GetWindowBottom (appWindow) - 3)
let c = 0;
while (FindPriorAttribute (attrib_highlight) && (c < 10))
  if (!IsPointInWindow (realWindow, GetCursorCol (), GetCursorRow ()) && (GetCurrentWindow () != appWindow)) then
    SayLine ()
    RestoreCursor ()
    return
  EndIf
  let c = c + 1
EndWhile
Say (msg480, ot_message) ; "Word in context not found "
EndScript

Script UpALevel()
var   int TheTypeCode
{Escape}
pause()
SaveCursor()
PCCursor()
let TheTypeCode = GetWindowSubTypeCode (GetCurrentWindow())
If (TheTypeCode == WT_MENU) then
  Say (msg3, ot_message) ;"Menu"
  SayWindow (GetCurrentWindow(), READ_HIGHLIGHTED)
  return
EndIf
if (TheTypeCode == WT_STARTMENU) then
  Say (msg4, ot_message) ;"Start Menu"
  SayWindow (GetCurrentWindow(), READ_HIGHLIGHTED)
  return
EndIf
if (TheTypeCode == WT_CONTEXTMENU) then
  Say (msg5, ot_message) ;"Context Menu"
  SayWindow (GetCurrentWindow(), READ_HIGHLIGHTED)
EndIf
EndScript

Script SayDefaultButton ()
var   string DefaultButtonName
if (DialogActive ()) then
  let DefaultButtonName = GetDefaultButtonName ()
  if (DefaultButtonName != msgNull) then
    if (GetVerbosity () == 0) then Say (msg70, ot_message) endif  ;"default button is"
    Say (DefaultButtonName, ot_message)
  else
    Say (msg444, ot_message) ; "Can not determine default button in this dialog box ")
  EndIf
else
  Say (msg71, ot_message) ;"not in a dialog box"
endif
EndScript

;**/5  MOUSE FUNCTIONS

Script  MouseLeft()
;MouseLeft Script
MouseLeft (GlobalMousePixel)
Say (msg72, ot_message) ;"Mouse Left"
EndScript

Script  MouseRight()
;MouseRight Script
MouseRight (GlobalMousePixel)
Say (msg73, ot_message) ;"Mouse Right"
EndScript

Script  MouseDown()
;MouseDown Script
MouseDown (GlobalMousePixel)
Say (msg74, ot_message) ;"Mouse Down"
EndScript

Script  MouseUp()
;MouseUp Script
MouseUp (GlobalMousePixel)
Say (msg75, ot_message) ;"Mouse Up"
EndScript

Script  ControlLeftMouseClick()
;Control Left Mouse Click
ControlLeftMouseClick ()
Say (msg76, ot_message) ;"Control Mouse Click"
EndScript

Script  ShiftLeftMouseClick()
;Shift Left Mouse Click
ShiftLeftMouseClick ()
Say (msg77, ot_message) ;"Shift Mouse Click"
EndScript

Script  AltLeftMouseClick()
AltLeftMouseClick ()
Say (msg77b, ot_message) ;"Alt Mouse Click"
EndScript
; **/6 End of Mouse Functions

Script JAWSFind ()
let InJAWSFind = TRUE ;flag that can be observed by other scripts
if IsVirtualPCCursor ()
then if JAWSFind () 
 then SayLine ()
let InJAWSFind = FALSE
Return
endif 
 EndIf
if JAWSFind () then SayWord () EndIf
let InJAWSFind = FALSE
EndScript

Script JAWSFindNext ()
var    int found
let found = JAWSFindNext ()
if (found==FALSE)
 then Say (msg78, ot_message)
 else Say (msg79, ot_message)
 EndIf  ; ["Found", "search string NOT found"]
EndScript

Script  HomeRowToggle()
If (ToggleHomeRow () == OFF) then Say (msg80, ot_message) Else Say (msg81, ot_message) EndIf ; ["Home Row Off", "Home Row On"]
EndScript

Script  MouseMovementDefault()
Let GlobalMousePixel = 3
Say (msg427, ot_message) ; "Mouse Pixel setting is "
SayInteger (GlobalMousePixel)
EndScript

Script MouseMovementDecrement ()
If (GlobalMousePixel == 1) then Let GlobalMousePixel = 50 Else Let GlobalMousePixel = GlobalMousePixel - 1 EndIf
SayInteger (GlobalMousePixel)
EndScript

Script  MouseMovementIncrement()
If (GlobalMousePixel == 50) then Let GlobalMousePixel = 1 Else Let GlobalMousePIxel = GlobalMousePixel + 1 EndIf
SayInteger (GlobalMousePixel)
EndScript

Script SayMouseAndAnsiSettings()
var   int SpeakAnsi
Say (msg89, ot_message) ;"Global Mouse Pixel is "
SayInteger (GlobalMousePixel)
Say (msg90, ot_message) ;"Speak Ansi Characters is set to "
Let SpeakAnsi = GetJcfOption (OPT_SPEAK_ANSI_CHARS)
If SpeakAnsi == 0 then Say (msg84, ot_message) EndIf   ;"No Ansi"
If SpeakAnsi == 1 then Say (msg85, ot_message) EndIf   ;"Some Ansi"
If SpeakAnsi == 2 then Say (msg86, ot_message) EndIf  ;"More Ansi"
If SpeakAnsi == 3 then	Say (msg87, ot_message) EndIf   ;"Most Ansi"
If SpeakAnsi == 4 then Say (msg82, ot_message) EndIf   ;"All Ansi"
EndScript

Script GraphicsMode ()
var
	int GraphicsMode
Let GraphicsMode = GetJcfOption (OPT_GRAPHICS_MODE)
If (GraphicsMode == 0) then
  If (SetJcfOption (OPT_GRAPHICS_MODE, 1) == WAS_SUCCESSFUL)  then
   Say (msg91, ot_message) ;"Active Graphics Mode"
  Else
    Say (msg92, ot_message) ;"Active Graphics Mode could not be set"
  EndIf ; WAS_SUCCESSFUL
Else
  If (SetJcfOption (OPT_GRAPHICS_MODE, 0) == WAS_SUCCESSFUL)  then
    Say (msg93, ot_message) ;"Standard Graphics Mode"
 Else
    Say (msg94, ot_message) ;"Standard Graphics Mode could not be set"
  EndIf ; WAS_SUCCESSFUL
EndIf  ; GraphicsMode == 0
EndScript

Script  SayColor()
SayColor ()
EndScript

Script MinimizeAllApps ()
MinimizeAllApps ()
Say (msg101, ot_message) ;"minimize all apps"
EndScript

Script MenuBar ()
ActivateMenuBar ()
Refresh ()
EndScript

Script StartMenu ()
ActivateStartMenu ()
EndScript

; Keep JAWS from saying "space" in an extended select list box
Script SelectCurrentItem ()
var int TheTypeCode
{control+space}
let TheTypeCode = GetWindowSubtypeCode (GetCurrentWindow())
if (TheTypeCode ==  WT_EXTENDEDSELECT_LISTBOX) then
  SayLine()
endif
EndScript

Int Function IsSelectScriptDlg()
var HANDLE hExecute
If (GetControlID(GetFirstChild(GetRealWindow(GetFocus()))) == ID_SELECT_DLG_LIST) then
  ;wn466 = "JAWS"
  If (GetWindowName (GetAppMainWindow (GetCurrentWindow ())) == wn466) then
    let hExecute = FindDescendantWindow (GetParent (GetCurrentWindow ()), ID_SELECT_DLG_EXECUTE)
    return (IsWindowVisible (hExecute))
  endif
endif
return FALSE
EndFunction

Int Function IsSelectItemDlg ()
var HANDLE hExecute
If (GetControlID(GetFirstChild(GetRealWindow(GetFocus()))) == ID_SELECT_DLG_LIST) then
  ;wn466 = "JAWS"
  If (GetWindowName (GetAppMainWindow (GetCurrentWindow ())) == wn466) then
    let hExecute = FindDescendantWindow (GetParent (GetCurrentWindow ()), ID_SELECT_DLG_EXECUTE)
   return !(IsWindowVisible (hExecute))
  endif
endif
return FALSE
EndFunction

Void Function ScreenSensitiveHelpVirtualCursor (int iWinType)
If (iWinType == WT_BUTTON) then
	Say (msg123, ot_help) ;"This is a Button"
	Say (msg170, ot_help) ;"Read current line or word to read it"
	Say (msg566, OT_HELP); "When activated, forms mode is turned on"
	Say (msg567, OT_HELP); "When the screen is redrawn, the Virtual PC Cursor is turned back on if appropriate"
	Say (msg124, ot_help) ;"Use enter to activate it"
	Say (msg568, OT_HELP); "use your navigation keys to continue reading the page"
	Return
EndIf
; for controls with state
If (iWinType == WT_CHECKBOX) ||
(iWinType == WT_RADIOBUTTON) then
	If (iWinType == WT_CHECKBOX) then
		Say (msg168, ot_help) ;"This is a check box"
		Say (msg170, ot_help) ;"Read current line or word to read it"
	ElIf (iWinType == WT_RADIOBUTTON) then
		Say (msg165, ot_help) ;"This is one of a group of radio buttons"
		Say (msg166, ot_help) ;"only one can be checked at a time"
	EndIf
Say (msg569, OT_MESSAGE); "Activating Forms Mode will toggle the state of this control"
	Say (msg570, OT_HELP); "Press enter to activate Forms Mode"
	Say (msg568, OT_HELP); "use your navigation keys to continue reading the page"
	Return
EndIf
; for editable controls
If (iWinType == WT_EDIT) ||
(iWinType == WT_EDITCOMBO) ||
(iWinType == WT_COMBOBOX) ||
(iWinType == WT_SPINBOX) then
	If (iWinType == WT_EDIT) then
		Say (msg572, OT_HELP); "This is an edit field"
	ElIf (iWinType == WT_EDITCOMBO) then
		Say (msg246, ot_help) ;"This is an edit Combo box"
	ElIf (iWinType == WT_COMBOBOX) then
		Say (msg126, ot_help) ;"This is a Combo box"
	ElIf (iWinType == WT_SPINBOX) then
		Say (msg150, ot_help) ;"This is a spin box"
	EndIf
	Say (msg574, OT_HELP); "Use SayLine to read its contents"
	Say (msg571, OT_HELP); "Activating forms mode will allow you to edit the contents of this control"
	Say (msg570, OT_HELP); "Press enter to activate Forms Mode"
	Say (msg568, OT_HELP); "use your navigation keys to continue reading the page"
	Return
EndIf
; for link and graphic window types
If (iWinType == WT_MAILTO_LINK) then
	Say (msg579, OT_HELP); "This is a Send Mail Link"
	Say (msg580, OT_HELP); "Read the current line to hear where the message is to be sent"
	Say (msg581, OT_HELP); "Press ENTER to activate your default e-mail application for composing and sending a message"
	Say (msg568, OT_HELP); "use your navigation keys to continue reading the page"
	Return
EndIf
If (iWinType == wt_ImageMap_link) ||
(iWinType == 	WT_BITMAP) ||
(iWinType == WT_LINK) ||
(iWinType == wt_ftp) then
	If (iWinType == wt_ImageMap_link) then
		Say (msg573, OT_HELP); "This is a link within an image map"
	ElIf (iWinType == 	WT_BITMAP) then
		Say (msg576, OT_HELP); "This is a bit map or graphic image"
		Say (msg577, OT_HELP); "If you heard the word link when reading it, then activating it will launch a new page"
	ElIf (iWinType == WT_LINK) then
		Say (msg578, OT_HELP); "This is a link"
	ElIf (iWinType == wt_ftp) then
		Say (msg582, OT_HELP); "This is an FTP link"
		Say (msg583, OT_HELP); "Activating it will start a download or open a directory on an FTP site"
	EndIf
	Say (msg574, OT_HELP); "Use SayLine to read its contents"
	Say (msg575, OT_HELP); "Press ENTER to activate it"
	Say (msg568, OT_HELP); "use your navigation keys to continue reading the page"
	Return
EndIf
EndFunction

Void Function ScreenSensitiveHelpForKnownClasses (int nSubTypeCode)
var
	int TheTypeCode,
	string RealName
let theTypeCode = nSubTypeCode
If (IsVirtualPCCursor ()) then
	If (TheTypeCode > 0) then
		ScreenSensitiveHelpVirtualCursor (TheTypeCode)
		Return
	EndIf
EndIf
if (TheTypeCode == WT_BUTTON) then ;#1
  Say (msg123, ot_help) ;"This is a Button"
  Say (msg124, ot_help) ;"Use enter to activate it"
  Say (msg125, ot_help) ;" Use Tab to move to the next Control"
  Return
EndIf
if (TheTypeCode == WT_COMBOBOX) then ;#2
  Say (msg126, ot_help) ;"This is a Combo box"
  Say (msg127, ot_help) ;"type in a value or use the arrow keys to move between the items"
  Say (msg127b, ot_help); " use the arrow keys to move between the items"
  Say (msg127c, ot_help); "use alt plus up arrow or Escape to close the list box"
  Say (msg128, ot_help) ;"Use the Tab key to move to the next Control"
  Return
EndIf
if (TheTypeCode == WT_EDIT) then ;#3
  Say (msg129, ot_help) ;"This is an edit field in which you can type information"
  Say (msg130, ot_help) ;"Use the left and right arrow keys to move through the entered text"
  Say (msg128, ot_help) ;"Use the Tab key to move to the next Control"
  Return
EndIf
if (TheTypeCode == WT_LISTBOX) then ;#4
  if (IsSelectScriptDlg()) then
    Say (msg460, ot_help) ;"This is an execute item list box"
    Say (msg132, ot_help) ;"Use the arrow keys or the first letter to move to an item"
    Say (msg461, ot_help) ;"Use the space bar to toggle the selected item"
    Say (msg462, ot_help) ;"Use the enter key to close this dialog"
  elif (IsSelectItemDlg()) then
    Say (msg463, ot_help) ;"this is a select item list box"
    Say (msg132, ot_help) ;"Use the arrow keys or the first letter to move to an item"
    Say (msg464, ot_help) ;"Use enter to choose the item and exit the dialog"
    Say (msg465, ot_help) ;"Use escape to cancel the dialog"
  else
    Say (msg131, ot_help) ;"This is a list box"
    Say (msg132, ot_help) ;"Use the arrow keys or the first letter to move to an item"
    Say (msg133, ot_help) ;"Use Enter to select it"
    Say (msg128, ot_help) ;"Use the Tab key to move to the next Control"
  endif
  Return
EndIf
if (TheTypeCode == WT_SCROLLBAR) ||
(TheTypeCode ==WT_LEFTRIGHTSCROLLBAR)
 then ;#5
	Say (msg134, ot_help) ;"This is a scroll bar"
	Say (msg135, ot_help) ;"Use the right arrow down arrow or page down keys to increase the value"
	Say (msg136, ot_help) ;"Use the left arrow up arrow or page up keys to decrease the value"
	Say (msg128, ot_help) ;"Use the Tab key to move to the next Control"
	Return
elif  (TheTypeCode ==WT_UPDOWNSCROLLBAR) Then
	Say (msg454, ot_help) ;"This is an Up Down scroll bar"
	Say (msg455, ot_help) ;"Use the right arrow down arrow or page down keys to decrease the value"
	Say (msg456, ot_help) ;"Use the left arrow up arrow or page up keys to increase the value"
	Say (msg128, ot_help) ;"Use the Tab key to move to the next Control"
EndIf
if (TheTypeCode == WT_STATIC) then ;#6
	Say (msg137, ot_help) ;"This is static text for information only"
	Say (msg138, ot_help) ;"Use the reading keys to read the text"
	Say (msg128, ot_help) ;"Use the Tab key to move to the next Control"
	Return
EndIf
if (TheTypeCode == WT_TOOLBAR) then ;#7
	Say (msg139, ot_help) ;"this is a tool bar"
	Say (msg140, ot_help) ;"it contains various controls and graphics"
	Say (msg141, ot_help) ;"it is generally accessed with the mouse by point and click"
	Say (msg142, ot_help) ;"most tool bar items can also be found within menus"
	Return
endif
if (TheTypeCode == WT_STATUSBAR) then ;#8
	Say (msg143, ot_help) ;"This is an application status bar"
	Say (msg144, ot_help) ;"It provides a variety of information depending on the focus"
	Say (msg145, ot_help) ;"by default jaws will read this with insert plus page down"
	Return
endif
if (TheTypeCode == WT_HEADERBAR) then ;#9
	Say (msg146, ot_help) ;"This is a header bar"
	Say (msg147, ot_help) ;"it contains titles for various columns below the header bar"
	Say (msg148, ot_help) ;"clicking on a particular title"
	Say (msg149, ot_help) ;"will generally sort the list based on the information in that column"
	Return
endif
if (TheTypeCode == WT_SPINBOX) then ;#12
	Say (msg150, ot_help) ;"This is a spin box"
	Say (msg151, ot_help) ;"you can edit this control manually or"
	Say (msg152, ot_help) ;"arrow up or down arrow to increase or decrease its value"
	Return
endif
;WT_MENU = 13,
if (TheTypeCode == WT_MENU) then
	Say (msg153, ot_help) ;"This is a menu"
	Say (msg154, ot_help) ;"Use the arrow keys to move between the items"
	Say (msg119, ot_help) ;"Use Say Character to read the hot key"
	Say (msg120, ot_help) ;"use the hotkey as a shortcut key or"
	Say (msg155, ot_help) ;"Press Enter to select the current item"
	Return
EndIf
;WT_DESKTOP = 14,
if (TheTypeCode == WT_DESKTOP) then
	Say (msg156, ot_help) ;"This is the desktop"
	Say (msg157, ot_help) ;"This is the area underlying all application windows"
	Return
EndIf
;WT_ICONTITLE = 16,
if (TheTypeCode == WT_ICONTITLE) then
	Say (msg158, ot_help) ;"This is an Icon Title resulting from a minimized group or application"
	If (IsJAWSCursor ()) then
		Say (msg159, ot_help) ;"Press the left mouse button to activate"
		Return
	EndIf
	If (IsPCCursor ()) then
		Say (msg160, ot_help) ;"Press enter to activate"
		Return
	EndIf
EndIf
;WT_MDICLIENT = 17,
if (TheTypeCode == WT_MDICLIENT) then
	Say (msg161, ot_help) ;"This is an multiple document interface client window"
	Say (msg162, ot_help) ;"This is the space underlying documents in an m d i environment"
	Return
EndIf
;WT_DIALOG = 18,
if (TheTypeCode == WT_DIALOG) then
	Say (msg163, ot_help) ;"This is a dialog box"
	Say (msg164, ot_help) ;"Use the tab keys to move between the fields"
	Return
EndIf
;WT_RADIOBUTTON = 19,
if (TheTypeCode == WT_RADIOBUTTON) then
	Say (msg165, ot_help) ;"This is one of a group of radio buttons"
	Say (msg166, ot_help) ;"only one can be checked at a time"
	Say (msg167, ot_help) ;"Use the up and down arrow keys to move the check mark"
	Say (msg128, ot_help) ;"Use the Tab key to move to the next Control"
	Return
EndIf
;WT_CHECKBOX = 20,
if (TheTypeCode == WT_CHECKBOX) then
	Say (msg168, ot_help) ;"This is a check box"
	Say (msg169, ot_help) ;"Use the space bar to toggle the check mark on and off"
	Say (msg170, ot_help) ;"Read current line or word to read it"
	Say (msg128, ot_help) ;"Use the Tab key to move to the next Control"
	Return
EndIf
;WT_GROUPBOX = 21,
if (TheTypeCode == WT_GROUPBOX) then
	Say (msg171, ot_help) ;"This is a groupbox"
	If (GetVerbosity () == 0) then
		Say (msg172, ot_help) ;"It is used to group items that are related"
		Say (msg173, ot_help) ;"such as radio buttons"
	EndIf
	Say (msg174, ot_help) ;"use the pc cursor to move between the controls"
	Return
EndIf
;WT_SDM = 23,
if (TheTypeCode == WT_SDM) then
	Say (msg163, ot_help) ;"This is a dialog box"
	Say (msg175, ot_help) ;"use tab and shift tab to move between the controls"
	Say (msg176, ot_help) ;"select ok to accept the changes or cancel to ignore the changes"
	Return
EndIf
;WT_GENERALPICTURE= 25,
if (TheTypeCode == WT_GENERALPICTURE) then
	Say (msg177, ot_help) ;"This is a General picture"
	Say (msg178 + msg179, ot_help) ;" functions or designs specific to the application"
	Return
EndIf
;WT_HOTKEY = 28,
if (TheTypeCode == WT_HOTKEY) then
	Say (msg180, ot_help) ;"This is a hot key or short cut key edit control"
	Say (msg181, ot_help) ;"be careful or you may define a short cut key by pressing any letter key"
	Say (msg182, ot_help) ;"or most combinations of letter key and alt control or shift"
	Say (msg183, ot_help) ;"use the tab key to move to the next control"
	Return
EndIf
;WT_TABCONTROL=29,
if (TheTypeCode == WT_TABCONTROL) then
	Say (msg184, ot_help) ;"This is a tab control found in multi page dialog boxes"
	Say (msg185, ot_help) ;"use the arrow keys to move between the tabs"
	Say (msg186, ot_help) ;"use the tab key to move between the controls in the dialog box"
	Return
EndIf
;WT_LISTVIEW=30,
if (TheTypeCode == WT_LISTVIEW) then
	let RealName = GetWindowName (GetRealWindow (GetCurrentWindow()))
;wn187="Desktop"
	if RealName == wn187 then
		Say (msg188, ot_help) ;"This is the desktop list view"
		Say (msg189, ot_help) ;"It contains shortcut icons"
		Say (msg190, ot_help) ;"use the arrow keys to move from item to item"
		Say (msg191, ot_help) ;"or press the first letter of the desired item"
		Say (msg192, ot_help) ;"Press enter or double click to select"
		Say (msg193, ot_help) ;"Press tab to move to the start button or shift + tab to move to the task bar"
		Say (msg194, ot_help) ;"if the desktop items are not being read correctly"
		Say (msg195, ot_help) ;"you may need to minimize all applications"
		Say (msg196, ot_help) ;"this can be accomplished with insert plus f6"
		Return
	else
		Say (msg197, ot_help) ;"This is a list view"
		Say (msg198, ot_help) ;"use the arrow keys to read through the items"
		Say (msg199, ot_help) ;"or press the first letter to jump to a desired item"
		Say (msg200, ot_help) ;"items can be contained in one or more columns"
		Say (msg201, ot_help) ;"to select a contiguous group of items"
		Say (msg202, ot_help) ;"hold down the shift key as you arrow up or down"
		Say (msg203, ot_help) ;"to select a non contiguous group of items"
		Say (msg204, ot_help) ;"hold down the control key as you arrow up and down"
		Say (msg205, ot_help) ;"and use control plus space bar"
		Say (msg206, ot_help) ;" to select or unselect items"
		Say (msg207, ot_help) ;"to here the items that have been selected"
		Say (msg208, ot_help) ;"use shift plus insert plus down arrow"
		Say (msg209, ot_help) ;"we recommend that you put files in a single column with all details"
		Say (msg210, ot_help) ;"by selecting details from the view menu"
		Return
	EndIf
EndIf
;WT_TREEVIEW=31,
if (TheTypeCode == WT_TREEVIEW) then
	Say (msg211, ot_help) ;"Tree view level "
	SayInteger (GetTreeViewLevel ())
	Say (msg212, ot_help) ;"use up or down arrow to read through the items"
	Say (msg213, ot_help) ;"or press the first letter to jump through the list"
	Say (msg214, ot_help) ;"use the right or left arrow keys to open or close an item or"
	Say (msg215, ot_help) ;"use shift with the plus or minus key"
	Say (msg216, ot_help) ;"to move to the prior level press backspace"
	Say (msg217, ot_help) ;"to move to the root of the tree press home"
	Say (msg218, ot_help) ;"to move to the last item on the tree press end"
	Return
EndIf
;WT_STARTBUTTON=32,
if (TheTypeCode == WT_STARTBUTTON) then
	Say (msg219, ot_help) ;"This is the start button"
	Say (msg220, ot_help) ;"Press Enter to open the start menu"
	Say (msg221, ot_help) ;"items in the start menu are used to launch applications"
	Say (msg222, ot_help) ;"or tab to move to the task bar"
	Say (msg223, ot_help) ;"you can use control plus escape to activate this menu at any time"
	Return
EndIf
;WT_STARTMENU=33,
if (TheTypeCode == WT_STARTMENU) then
	Say (msg224, ot_help) ;"This is the start menu"
	Say (msg225, ot_help) ;"items in this menu are used to launch applications"
	Say (msg226, ot_help) ;"Use up or down arrow to move between the items"
	Say (msg119, ot_help) ;"Use Say Character to read the hot key"
	Say (msg155, ot_help) ;"Press Enter to select the current item"
	Return
EndIf
;WT_CONTEXTMENU=34,
if (TheTypeCode == WT_CONTEXTMENU) then
	Say (msg227, ot_help) ;"This is the context menu"
	Say (msg226, ot_help) ;"Use up or down arrow to move between the items"
	Say (msg119, ot_help) ;"Use Say Character to read the hot key"
	Say (msg155, ot_help) ;"Press Enter to select the current item"
	Return
EndIf
;WT_task bar=35
if (TheTypeCode == WT_TASKBAR) then
	Say (msg228, ot_help) ;"This is the task bar"
	Say (msg229, ot_help) ;" it contains the currently running applications"
	Say (msg185, ot_help) ;"use the arrow keys to move between the tabs"
	Say (msg230, ot_help) ;" use enter to invoke the application"
	Say (msg231, ot_help)	 ;"use alt plus enter to open the task bar properties dialog"
	Say (msg232, ot_help) ;"use the tab key to move to the desktop"
	Return
EndIf
;WT_MULTISELECT_LISTBOX=37,
if (TheTypeCode == WT_MULTISELECT_LISTBOX) then
	Say (msg233, ot_help) ;"This is a multiselect listbox"
	Say (msg201, ot_help) ;"to select a contiguous group of items"
	Say (msg234, ot_help) ;"hold down the shift key as you arrow up and down"
	Say (msg203, ot_help) ;"to select a non contiguous group of items"
	Say (msg204, ot_help) ;"hold down the control key as you arrow up and down"
	Say (msg235, ot_help) ;"and use the space bar to select the item"
	Say (msg207, ot_help) ;"to here the items that have been selected"
	Say (msg208, ot_help) ;"use shift plus insert plus down arrow"
	Return
endif
;WT_EXTENDEDSELECT_LISTBOX=38,
if (TheTypeCode == WT_EXTENDEDSELECT_LISTBOX) then
	Say (msg236, ot_help) ;"This is an extended select list box"
	Say (msg201, ot_help) ;"to select a contiguous group of items"
	Say (msg234, ot_help) ;"hold down the shift key as you arrow up and down"
	Say (msg237, ot_help) ;"use shift + f8 to toggle the extended select option"
	Say (msg238, ot_help) ;"When the extended select option is on"
	Say (msg239, ot_help) ;"you can select multiple items with your space bar"
	Say (msg207, ot_help) ;"to here the items that have been selected"
	Say (msg208, ot_help) ;"use shift plus insert plus down arrow"
	Return
endif
if (TheTypeCode == WT_LEFTRIGHTSLIDER) then ;#39
	Say (msg240, ot_help) ;"This is a horizontal slider"
	Say (msg241, ot_help) ;"the value of the control increases as you move to the right"
	Say (msg242, ot_help) ;"this type of control is frequently used to control settings such as"
	Say (msg243, ot_help) ;"volume or pitch"
	Return
endif
if (TheTypeCode == WT_UPDOWNSLIDER) then ;#40
	Say (msg244, ot_help) ;"This is a vertical slider"
	Say (msg245, ot_help) ;"the value of the control increases as you move upward"
	Say (msg242, ot_help) ;"this type of control is frequently used to control settings such as"
	Say (msg243, ot_help) ;"volume or pitch"
	Return
endif
;WT_EDITCOMBO = 41
if (TheTypeCode == WT_EDITCOMBO) then ;#41
	Say (msg246, ot_help) ;"This is an edit Combo box"
	Say (msg127, ot_help) ;"type in a value or use alt plus down arrow to open the list box"
	Say (msg127b, ot_help); " use the arrow keys to move between the items"
	Say (msg127c, ot_help); "use alt plus up arrow or Escape to close the list box"
	Say (msg128, ot_help) ;"Use the Tab key to move to the next Control"
	Say (msg247 + msg248, ot_help) ;" previously selected items"
	Return
endif
;WT_PASSWORDEDIT=42,
if (TheTypeCode == WT_PASSWORDEDIT) then ;#42
	Say (msg249, ot_help) ;"This is a password edit control"
	Say (msg250 + msg251, ot_help) ;" visually replaced by asteriks"
	Say (msg252, ot_help) ;"Use the backspace to delete and start over"
	Say (msg128, ot_help) ;"Use the Tab key to move to the next Control"
	Return
endif
if (TheTypeCode == WT_READONLYEDIT) then ;#43
	Say (msg253, ot_help) ;"This text is reed only"
	Say (msg254, ot_help) ;"you can navigate and read text with the jaws cursor"
	Say (msg255, ot_help) ;"but you cannot edit the text"
	Return
endif
if (theTypeCode == WT_COMMANDBAR) then ;#44
	Say (msg406, ot_help);"This is a command bar"
	Say (msg407, ot_help);"it consists of a row of buttons"
	Say (msg408, ot_help) ;"you can arrow left or right to hear the different button names"
	Say (msg409, ot_help) ;"and press enter to activate a button"
	Say (msg410, ot_help) ;"press control plus tab to move to the next command bar"
	Say (msg411, ot_help) ;"press escape to leave the command bar"
	return
endif
if (GlobalMenuMode == MENUBAR_ACTIVE) then
	Say (msg117, ot_help) ;"This is the menu bar"
	Say (msg118, ot_help) ;"you can arrow left and right to hear the different menu names"
	Say (msg119, ot_help) ;"Use Say Character to read the hot key"
	Say (msg120, ot_help) ;"use the hotkey as a shortcut key or"
	Say (msg121, ot_help) ;"press enter or down arrow to open a menu"
	Say (msg122, ot_help) ;"press escape to exit the menu bar"
	return
endif
;if it gets this far it did not recognize the type code.
Say (msg256, ot_help) ;"The Type Code is"
SayInteger (TheTypeCode)
ScreenSensitiveHelpForUnknownClasses (); catch everything not yet handled
EndFunction

Script ScreenSensitiveHelp ()
var
	handle WinHandle,
	int TheTypeCode,
	String TheClass
if (IsSameScript ()) then
	AppFileTopic()
	return
EndIf
if (GlobalMenuMode == 1) then
	ScreenSensitiveHelpForKnownClasses (wt_MenuBar);
	return
EndIf
let WinHandle = GetCurrentWindow ()
let TheTypeCode = GetWindowSubTypeCode (WinHandle)
if (TheTypeCode < 1) then
	let TheClass = GetWindowClass (WinHandle)
	if (theClass == wcTTY || theClass == wcTTYGrab) then
		Say (msg422, ot_help) ;"This is a DOS Window"
		Say (msg423, ot_help) ;"you can close this window by typing exit and pressing the enter key"
		Say (msg424, ot_help) ;"to switch between this window and your other applications"
		Say (msg425, ot_help) ;"use alt + tab"
		return
	endif
	ScreenSensitiveHelpForUnknownClasses()  ; handle unknown window types and classes
else
	ScreenSensitiveHelpForKnownClasses (theTypeCode); known types
EndIf
EndScript

Function ScreenSensitiveHelpForUnknownClasses ()
var
	String TheClass
let TimesPressedDefault = 0
If (GetCurrentWindow ()) then ;window handle is not 0
	Let TheClass = GetWindowClass (GetCurrentWindow ())
	Say (msg116, ot_help) ;"This is a custom window type"
	Say (msg257, ot_help) ;"Control i d = "
	SayInteger (GetCurrentControlID ())
	Say (msg258, ot_help) ;"class ="
	Say (TheClass, ot_help)
	SpellString (TheClass)
else ; handle = 0
	Say (msg259, ot_help) ;"there is currently no item with focus"
	Say (msg260, ot_help) ;"press insert+f6 to get to the desk top"
	Say (msg261, ot_help) ;"or alt plus tab to read the apps on the task bar"
	Say (msg261b, ot_help);"or control+escape for the start menu"
EndIf
EndFunction

Script  ScreenSensitiveHelpTechnical()
var
	String TheClass
Let TheClass = GetWindowClass (GetCurrentWindow ())
Say (msg257, ot_help) ;"Control i d = "
SayInteger (GetCurrentControlID ())
Say (msg258, ot_help) ;"class ="
Say (TheClass, ot_help)
SpellString (TheClass)
Say (msg429, ot_help) ; " Handle = "
SayInteger (GetCurrentWindow ())
EndScript

Script WindowKeysHelp ()
WindowKeysHelpDefault ()
EndScript

; List of some basic Windows keyboar commands
Void Function WindowKeysHelpDefault ()
Say (msg262, ot_help) ;"The Following windows keyboard commands can be useful"
Say (msg269, ot_help) ;"To open the start menu use control plus escape"
Say (msg270, ot_help) ;"for windows help press f1"
Say (msg271, ot_help) ;"to exit an application use alt plus f4"
Say (msg268, ot_help) ;"to access an application menu bar use the alt key"
Say (msg272, ot_help);"to rotate between the taskbar start button and desktop"
Say (msg272b + msg272c, ot_help);"press control plus escape escape and then press tab to "
		 ;" cycle between the three"
Say (msg273, ot_help) ;"to display a context menu for a selected item use shift plus f10"
Say (msg274, ot_help)		 ;"to display the properties dialog use alt plus enter"
EndFunction

Void Function CursorShapeChangedEvent (string CursorType)
Let GlobalCursorType = CursorType
	PerformScript SayCursorType ()
EndFunction

String Function ConvertCursorShape (string CursorType)
Let GlobalCursorType = CursorType
If (GlobalCursorType ==normal) then
	Say (msg275, ot_cursor) ;"Arrow Cursor"
	Return
EndIf
If (GlobalCursorType == editCursor) then
	Say (msg276, ot_cursor) ;"I beam cursor"
	Return
EndIf
If (GlobalCursorType ==WAIT) then
	Say (msg276a, ot_cursor)
	Return
EndIf
If (GlobalCursorType =="CROSS") then
	Say (msg277, ot_cursor) ;"cross hair cursor"
	Return
EndIf
Say (GlobalCursorType, ot_cursor) ;"Cursor Changed"
EndFunction

Script SayCursorType()
if GetWindowsOS ()==	OS_WIN_NT
then Say (msg556, OT_STRING)
 return
else
Say (convertCursorShape(getCursorShape()), OT_STRING)
endif
EndScript

Void Function HotKeyHelpDefaultLoop ()
var
	handle WinHandle,
	String RealClassName,
	String HelpPhrase,
	handle Hndl,
	int FoundHotKey,
	int SDMControlHandle,
	int WinTypeCode,
	int IsDialog

Let FoundHotKey = 0
Let IsDialog = DialogActive ()
Let hndl = GetRealWindow (GetFocus ())
Let RealClassName = GetWindowClass (hndl)
InvisibleCursor ()
;wn286="sdm"
if (StringContains (RealClassName, wn286)) then ; THIS IS AN SDM WINDOW
	Let IsDialog = ACTIVE
	Let WinHandle = GetRealWindow (GetFocus ())
	Let SDMControlHandle = SDMGetFirstControl (WinHandle)
	While (SDMControlHandle)
		MoveToControl (WinHandle, SDMControlHandle)
		;wn287=""
		if (GetHotKey () != wn287) then
			if ((FoundHotKey == 0) && (GetVerbosity() == BEGINNER)) then
				Say (msg288, ot_help) ;"Hot keys are as follows"
			EndIf
			;wn289=" use alt  "
			Let HelpPhrase = GetChunk () + wn289 + GetHotKey ()
			Say (HelpPhrase, ot_help)
			let FoundHotKey = 1
		EndIf
		if (IsMultiPageDialog ()) then
			let WinHandle = GetCurrentWindow()
		EndIf
		let SDMControlHandle = SDMGetNextControl (WinHandle, SDMControlHandle)
	EndWhile
else ; Not SDM Window
	Let WinHandle = GetRealWindow (GetFocus ())
	Let WinHandle=GetFirstChild (WinHandle)
	While (WinHandle)
		let WinTypeCode = GetWindowTypeCode (WinHandle)
		If ((WinTypeCode == WT_BUTTON) ||
			(WinTypeCode == WT_STATIC) ||
			(WinTypeCode == WT_RADIOBUTTON) ||
			(WinTypeCode == WT_CHECKBOX) ||
			(WinTypeCode == WT_GROUPBOX) ||
			(WinTypeCode == WT_3STATE) ||
			(WinTypeCode == WT_TABCONTROL)) then
			MoveToWindow (WinHandle)
			If hndl != GetRealWindow (GetCurrentWindow ()) then
				PCCursor ()
				return
			EndIf
			;wn287=""
			if (GetHotKey() != wn287) then
				if ((FoundHotKey == 0) && (GetVerbosity() == BEGINNER)) then
					Say (msg288, ot_help) ;"Hot keys are as follows"
				EndIf
				;wn289=" use alt  "
				Let HelpPhrase = GetChunk () + wn289 + GetHotKey()
				Say (HelpPhrase, ot_help)
				let FoundHotKey = 1
			EndIf
		EndIf ; condition for static text or button
		Let WinHandle = GetNextWindow (WinHandle)
	EndWhile
EndIf
PcCursor ()
If (FoundHotKey == 0) then
	If (IsDialog) then ;only say this string if in a dialog
		;"unable to determine hot keys in this dialog"
		Say (msg450, ot_help)
	EndIf
	GeneralJAWSHotKeys ()
EndIf
EndFunction

Void Function GeneralJAWSHotKeys ()
Say (msg292, ot_help) ;"Here are some jaws hot keys for general use"
Say (msg293 + GetScriptKeyName ("ScreenSensitiveHelp"), ot_help) ;"Screen sensitive help message use Insert plus F1"
Say (msg475 + GetScriptKeyName ("ScreenSensitiveHelp") + msg476, ot_help) ; "JAWS Help for applications Use Insert+F1 pressed twice quickly"
Say (msg294 + GetScriptKeyName ("WindowKeysHelp"), ot_help) ;"Windows tips on navigation Use Insert plus W"
Say (msg295 + GetScriptKeyName ("SayWindowTitle"), ot_help) ;"to reed window titles use Insert plus T"
Say (msg296 + GetScriptKeyName ("JAWSWindow"), ot_help) ;"to activate JAWS window use Insert plus J "
Say (msg297 + GetScriptKeyName ("MinimizeAllApps"), ot_help) ;"To minimize all applications on the desktop use insert plus f6"
Say (msg298 + GetScriptKeyName ("ShutDownJAWS"), ot_help) ;"to unload jaws at any time use Insert plus F4"
Say (msg477 + GetScriptKeyName ("RunJAWSManager"), ot_help) ; To open a JAWS utility such as Configuration Manager or Keyboard Manager use "
Say (msg302 + GetScriptKeyName ("JAWSFind"), ot_help) ;"to access the Jaws search dialog use Insert plus Control plus F "
Say (msg303 + GetScriptKeyName ("AdjustJAWSVerbosity"), ot_help) ;"to toggle verbosity levels use Insert plus V "
Say (msg305 + GetScriptKeyName ("SayColor"), ot_help) ;"to Say the screen color at the active cursor use Insert plus numbers row 5"
Say (msg306 + GetScriptKeyName ("RestrictJAWSCursor"), ot_help) ;"to Restrict the jaws Cursor use Insert plus R"
Say (msg307 + GetScriptKeyName ("SayFont"), ot_help) ;"to identify font at the active cursor use Insert plus F "
Say (msg308 + GetScriptKeyName ("ReadBoxInTabOrder"), ot_help) ;"to Reed Dialog Box in Tab Order use Insert plus B"
Say (msg309 + GetScriptKeyName ("RefreshScreen"), ot_help) ;"to refresh screen use Insert plus escape  "
Say (msg310, ot_help) ;"For a more complete list activate the JAWS Window"
Say (msg311, ot_help) ;"Press ALT+H and then Q for Quick Reference"
EndFunction

Int Function JAWSHotKeys ()
if (IsSelectScriptDlg ()) then
	Say (msg467, ot_help) ;"This is an execute item dialog"
	;msg468 = "Use "	msg469 = " for help specific to each control"
	Say (msg468 + GetScriptKeyName ("ScreenSensitiveHelp") + msg469, ot_help)
	Say (msg470, ot_help) ;"to execute the selected item once use alt e"
	Say (msg471, ot_help) ;"to exit this dialog use enter or escape"
	return TRUE
elif (IsSelectItemDlg ()) then
	Say (msg472, ot_help) ;"this is a select item dialog"
	;msg468 = "Use "	msg469 = " for help specific to each control"
	Say (msg468 + GetScriptKeyName ("ScreenSensitiveHelp") + msg469, ot_help)
	Say (msg464, ot_help) ;"Use enter to choose the item and exit the dialog"
	Say (msg465, ot_help) ;"Use escape to cancel the dialog"
	return TRUE
endif

return FALSE
EndFunction

; Insert H help messages
Script HotKeyHelp()
if (JAWSHotKeys()) then
	return
endif
HotKeyHelpDefaultLoop ()  ; standard dialog boxes
EndScript

Int Function HotKeyHelpDefault ()
;may not be correct always, hard coded, may remove it, 4/11/97, th
; Insert h text for Open File Dialog box.
;wn312="File Open"
var int ID
let ID = GetControlID(GetFocus())

if (GetWindowName (GetRealWindow (GetFocus())) == wn312) ||
	;wn313="Save"
	(GetWindowName (GetRealWindow (GetFocus())) == wn313) then
	Say (msg314, ot_help) ;"you can type in a path and file name then enter or"
	Say (msg315, ot_help) ;"You can Tab through the controls or jump using the following Windows hot keys"
	Say (msg316, ot_help) ;"For the list of disk drives, use Alt V then type the drive letter"
	Say (msg317, ot_help) ;"To select the path use Alt D for the directories list box"
	Say (msg318, ot_help) ;"Now type the first letter for each directory or subdirectory"
	Say (msg319, ot_help) ;"To choose the type of files you are looking for, Use Alt T"
	Say (msg320, ot_help) ;"Now arrow thru the list to find your choice"
	Say (msg321, ot_help) ;"Use Alt N to return to File Name edit box and type in a name or tab to list box"
	Say (msg322, ot_help) ;"Now you can type the first letter of the file you want and then enter"
	Say (msg323, ot_help) ;"Use escape to cancel"
	Return TRUE
EndIf
; Insert h text for Save As Dialog box.
;wn324="Save As"
if (GetWindowName (GetRealWindow (GetFocus())) == wn324) then
	Say (msg325, ot_help) ;"type in a path and file name then enter or"
	Say (msg315, ot_help) ;"You can Tab through the controls or jump using the following Windows hot keys"
	Say (msg316, ot_help) ;"For the list of disk drives, use Alt V then type the drive letter"
	Say (msg317, ot_help) ;"To select the path use Alt D for the directories list box"
	Say (msg318, ot_help) ;"Now type the first letter for each directory or subdirectory"
	Say (msg326, ot_help) ;"To choose the file type you would like to save it as, Use Alt T"
	Say (msg327, ot_help) ;"Use the down arrow and find your choice"
	Say (msg328, ot_help) ;"Use Alt N to return to File Name edit box and type in a name"
	Say (msg323, ot_help) ;"Use escape to cancel"
	Return TRUE
EndIf
; Insert h for Print Setup dialog.
;wn329="Print Setup"
if (GetWindowName (GetRealWindow (GetFocus())) == wn329) then
	Say (msg330, ot_help) ;"Tab through the controls to make selections or use the following Windows keys"
	Say (msg331, ot_help) ;"To select Default printer use Alt D"
	Say (msg332, ot_help) ;"To select specific printer use Alt P"
	Say (msg333, ot_help) ;"To select Paper size use Alt Z"
	Say (msg334, ot_help) ;"To select Paper source use Alt S"
	Say (msg335, ot_help) ;"Printing Portrait use Alt R"
	Say (msg336, ot_help) ;"Printing Landscape use Alt L"
	Say (msg337, ot_help) ;"For other printing options use Alt O"
	Return TRUE
EndIf
Return FALSE  ; did not handle
EndFunction

Script SayCurrentHotKey()
;wn287=""
if (GetHotKey() == wn287) then
	Say (msg338, ot_help) ;"no hot key"
	return
endif
Say (GetHotKey(), ot_help)
EndScript

Void Function MoveToFirstSdmControl ()
var
	int SDMControl,
	handle winhandle
let winhandle = GetRealWindow (GetFocus())
let SDMControl = SDMGetFirstControl (winhandle)
MoveToControl (winhandle, SDMControl)
let GlobalSDMControl = SDMControl
EndFunction

Void Function MoveToNextSdmControl ()
var
	int SDMControl,
	handle winhandle
let winhandle = GetRealWindow (GetFocus())
let SDMControl = SDMGetNextControl (GetCurrentWindow(), GlobalSDMControl)
MoveToControl (GetCurrentWindow(), SDMControl)
let GlobalSDMControl = SDMControl
EndFunction

;Copyright 1996 by Henter-Joyce, Inc.
;default Script file for desk tops
; 2/12/95, added SDM windows, focus change & insert+f1 Scripts.
; 4/27, added PassKeyThrough
; & separated to use include file.
; added hjglobal.jmh header file
;and new Focus Change,8/8/95, th.

Script  ScriptFileName()
ScriptAndAppNames(msg505) ;"default"
EndScript

Script  SayLine()
let globalSayingCurrentItem = 1
SayLine ()
let globalSayingCurrentItem = 0
EndScript

Script  SayCharacter()
if IsPCCursor() then
	if (GetWindowTypeCode(GetCurrentWindow()) == WT_SLIDER) then
		SayWord() ; says the current setting
		return
	endif
endif
if (IsSameScript ()) then
	SayCharacterPhonetic ()
	AddHook (HK_SCRIPT, "PhoneticSpellHook")
else
	let globalSayingCurrentItem = 1
	SayCharacter()
	let globalSayingCurrentItem = 0
EndIf
EndScript

Void Function PhoneticSpellHook (string ScriptName)
if (ScriptName == "SayNextCharacter") then
	NextCharacter ()
	SayCharacterPhonetic ()
	return False
EndIf
if (ScriptName == "SayPriorCharacter") then
	PriorCharacter ()
	SayCharacterPhonetic ()
	return False
EndIf
RemoveHook (HK_SCRIPT, "PhoneticSpellHook")
return True
EndFunction

Script SayWord()
If (IsSameScript ()) Then
	SpellWord()
	AddHook (HK_SCRIPT, "SpellWordHook")
Else
	let globalSayingCurrentItem = 1
	SayWord()
	let globalSayingCurrentItem = 0
EndIf
EndScript

Void Function SpellWordHook (string ScriptName)
if (ScriptName == "SayNextWord") then
	NextWord ()
	SpellWord ()
	return false
EndIf
if (ScriptName == "SayPriorWord") then
	PriorWord ()
	SpellWord ()
	return false
EndIf
RemoveHook (HK_SCRIPT, "SpellWordHook")
return true
EndFunction

Script SayNextWord()
NextWord()
if ((IsLeftButtonDown()) || (IsRightButtonDown())) then
	SelectingText(TRUE)
	pause ()
	SelectingText(false)
	return
EndIf
SayWord()
EndScript

Script SayPriorWord()
PriorWord()
if ((IsLeftButtonDown()) || (IsRightButtonDown())) then
	SelectingText(TRUE)
	pause ()
	SelectingText(false)
	return
EndIf
SayWord()
EndScript

Script  SayActiveCursor()
if (IsLeftButtonDown ()) then
	Say (msg430, ot_message) ; "the left mouse button is locked"
EndIf
If (IsRightButtonDown ()) then
	Say (msg431, ot_message) ; "the right mouse button  is locked"
EndIf
SayActiveCursor()
SayCursorPos(GetActiveCursor())
EndScript

Script  RouteJawsCursorToPc()
if  IsVirtualPCCursor ()
then Refresh ()  
RouteJAWSToPc ()
JAWSCursor ()
Say (msg564, ot_string)
return
elif (IsInvisibleCursor ()) then
	RouteInvisibleToPc ()
	Say (msg377, ot_message) ;"Route invisible to p c"
else
	RouteJawsToPc()
	JAWSCursor()
	Say (msg378, ot_message) ;"Route jaws to p c"
endif
EndScript

Script  RoutePCCursorToJaws()
if  IsVirtualPCCursor ()
then 
Say (msg563, ot_string)
return
endif
if (IsInvisibleCursor ()) then
	RoutePCToInvisible ()
	Say (msg379b, ot_message) ;"Route p c to invisible"
else
	RoutePcToJaws()
	Say (msg379, ot_message) ;"Route p c to jaws"
endif
PCCursor()
EndScript

Script  SayAll()
SayAll()
EndScript

Script  LeftMouseButton()
Say (msg380, ot_message) ;"left mouse button"
LeftMouseButton()
EndScript

Script  RightMouseButton()
Say (msg381, ot_message) ;"right mouse button"
RightMouseButton()
EndScript

; toggle the pressed/released state of the left mouse button
Script  LeftMouseButtonLock()
if LeftMouseButtonLock () then
	Say (msg382, ot_message) ;"left button locked"
else
	Say (msg383, ot_message) ;"Left button unlocked"
endif
EndScript

Globals
	int DragAndDropSet,
	int DragFromX,
	int DragFromY,
	string DragObject

Script DragAndDrop ()
var
	int x,
	int y,
	String strObject
if (DragAndDropSet == false) then
	let DragFromX = GetCursorCol ()
	let DragFromY = GetCursorRow ()
	let DragObject = GetWord ()
	let DragAndDropSet = true
	; msg412 = "place the JAWS or PC cursor in the drop location and press "
	Say (msg412 + GetCurrentScriptKeyName () + msg413, ot_message)
	return
EndIf
SaveCursor ()
let x = GetCursorCol ()
let y = GetCursorRow ()
JawsCursor ()
; make sure that the left mouse button is unlocked
If IsLeftButtonDown () then
	LeftMouseButtonLock ()
	pause ()
EndIf
MoveTo (DragFromX, DragFromY)
Pause ()
let strObject = GetWord()
if strObject != DragObject then
	Let DragAndDropSet = false
	Say (msg415, ot_message) ; "Object to be dragged not found"
	Say (msg416, ot_message) ; "this may be because it has been covered by another window"
	Say (msg417, ot_message) ; "drag and drop action has been canceled"
	return
EndIf
LeftMouseButtonLock () ; lock it down
pause ()
MoveTo (x,y)
Pause ()
;msg418 = "dragging "
Say (Msg418 +strObject+msg419, ot_message)
SayWord()
LeftMouseButtonLock ()
RestoreCursor ()
Let DragAndDropSet = false
EndScript

Function DragAndDropClearValues ()
let DragAndDropSet = false
EndFunction

; toggle the pressed/released state of the right mouse button
Script RightMouseButtonLock ()
if RightMouseButtonLock () then
	Say (msg384, ot_message) ;"right button locked"
else
	Say (msg385, ot_message) ;"right button unlocked"
EndIf
EndScript

Script SayTopLineOfWindow()
SaveCursor()
InvisibleCursor()
RouteInvisibleToPC()
JawsPageUp()
SayLine()
RestoreCursor()
EndScript

Script SayBottomLineOfWindow()
var
	int TheTypeCode
let TheTypeCode = GetWindowSubtypeCode (GetCurrentWindow())
SaveCursor()
InvisibleCursor()
RouteInvisibleToPC()
if (TheTypeCode == WT_MENU) then
	MoveToWindow (GetAppMainWindow (GetCurrentWindow()))
	JAWSPageDown ()
	JAWSHome()
	NextWord()
	SayChunk()
else
	JawsPageDown()
	SayLine()
endif
RestoreCursor()
EndScript

Script  SayToCursor()
SayToCursor()
EndScript

Script  SayFromCursor()
SayFromCursor()
EndScript

Script  SayWindowPromptAndText()
SayWindowTypeAndText(GetCurrentWindow())
EndScript

Function Unknown (string TheName, int IsScript)
if IsScript &&
	GetAppFileName ()=="JFW.exe"
	 then Say (msg560, OT_text)
ElIf (IsScript) then
	Say (msg432 + TheName, ot_message) ; "unknown script call to "
else
	Say (msg433 + TheName, ot_message) ; "unknown function call to "
EndIf
EndFunction

;*************************
;     Utility Scripts         *
;*************************
Script  UtilityHelp()
;{homerow + insert+ h}
Say (msg339, ot_help) ;"Define current window use f1"
Say (msg340, ot_help) ;"Move to next window use tab"
Say (msg341, ot_help) ;"Move to prior window use shift plus tab"
Say (msg342, ot_help) ;"Move to child window use f2"
Say (msg343, ot_help) ;"Move to parent window use shift plus f2"
Say (msg344, ot_help) ;"Move to next attribute use grave accent"
Say (msg345, ot_help) ;"Move to prior attribute use shift plus grave accent"
Say (msg346, ot_help) ;"Move to first attribute use control plus grave accent"
Say (msg347, ot_help) ;"Move to last attribute use control plus shift plus grave accent"
Say (msg348, ot_help) ;"Adjust the output mode use f3"
Say (msg349, ot_help) ;"Adjust the Font mode use f4"
Say (msg350, ot_help) ;"Read the Prior Window use p"
EndScript

; Find the next requested attribute after the caret
Script  UtilityNextAttribute()
;{homerow+grave accent}
If (UT_FontMode == 0) then
	Let UT_FontMode = ATTRIB_BOLD
EndIf
If (FindNextAttribute (UT_FontMode)) then
	SayField ()
	return
endif
if (FindFirstAttribute (UT_FontMode)) then
	beep()
	SayField ()
	return
endif
Say (msg351, ot_message) ;"next attribute not found"
EndScript

; Find the prior requested attribute before the caret
Script  UtilityPriorAttribute()
;{homerow+shift+grave accent}
If (UT_FontMode == 0) then
	Let UT_FontMode = ATTRIB_BOLD
EndIf
If (FindPriorAttribute (UT_FontMode)) then
	SayField ()
	return
endif
If (FindLastAttribute (UT_FontMode)) then
	beep()
	SayField()
	return
endif
Say (msg352, ot_message) ;"prior attribute not found"
EndScript

; Find the first requested attribute
Script  UtilityFindFirstAttribute()
;{homerow + control + grave accent}
If (UT_FontMode == 0) then
	Let UT_FontMode = ATTRIB_BOLD
EndIf
If (FindFirstAttribute (UT_FontMode)) then
	SayWord ()
Else
	Say (msg353, ot_message) ;"First Attribute not found"
EndIf
EndScript

; Find the last requested attribute
Script  UtilityFindLastAttribute()
;{homerow + shift+control + grave accent}
If (UT_FontMode == 0) then
	Let UT_FontMode = ATTRIB_BOLD
EndIf
If (FindLastAttribute (UT_FontMode)) then
	SayWord ()
Else
	Say (msg354, ot_message) ;"Last Attribute not found"
EndIf
EndScript

; produces the requested ouput on the current window
Script  UtilitySayInfoAccess()
;{homerow+f1}
var
	HANDLE hGrip,
	Int bSpellMode
Let hGrip = GetCurrentWindow ()
If (IsSameScript ()) then
	Let bSpellMode = ON
Else
	Let bSpellMode = OFF
EndIf
UtilitySayInfo(hGrip, bSpellMode)
EndScript

Script  UtilityPutInfoInBox()
;{homerow + Insert + f1}
If (UT_OutputMode == UT_FOCUS ||
   UT_OutputMode == UT_CONTROLID ||
   UT_OutputMode == UT_SUBTYPE	) then
	Say (msg355, ot_message) ;"Message box not available for Focus or Control ID"
EndIf
If UT_OutputMode == UT_CLASS then
	Say (GetWindowClass (GetCurrentWindow ()), ot_window_information)
	MessageBox (GetWindowClass (GetCurrentWindow ()))
EndIf
If UT_OutputMode == UT_TYPE then
	Say (GetWindowType (GetCurrentWindow ()), ot_window_information)
	MessageBox (GetWindowType (GetCurrentWindow ()))
EndIf
If UT_OutputMode == UT_REALNAME then
	Say (GetWindowName (GetRealWindow (GetCurrentWindow ())), ot_window_information)
	MessageBox (GetWindowName (GetRealWindow (GetCurrentWindow ())))
EndIf
EndScript
Script  UtilityMoveToNextWindow()
;{homerow+shift+tab}
var
	HANDLE hGrip
let hGrip = GetNextWindow(getCurrentWindow())
while  (hGrip && !IsWindowVisible(hGrip))
let hGrip = GetNextWindow(hGrip)
endwhile
if  (hGrip && MoveToWindow (hGrip)) then
UtilitySayInfo(hGrip, FALSE) ;produces the requested output
else
Say (msg481, ot_message) ; "no next window"
endif
EndScript

;Cycle backword through windows at the same level
Script  UtilityMoveToPriorWindow()
;{homerow+shift+tab}
var
	HANDLE hGrip
let hGrip = GetPriorWindow(GetCurrentWindow())
while  (hGrip && !IsWindowVisible(hGrip))
let hGrip = GetPriorWindow(hGrip)
endwhile
if  (hGrip && MoveToWindow (hGrip)) then
UtilitySayInfo(hGrip, FALSE) ;produces the requested output
else
Say (msg482, ot_message) ; "no prior window"
endif
EndScript

;Move down one level
Script  UtilityMoveToChild()
;{homerow+f2}
var
	HANDLE hGrip
let hGrip = GetFirstChild(getCurrentWindow())
while  (hGrip && !IsWindowVisible(hGrip))
let hGrip = GetNextWindow(hGrip)
endwhile
if  (hGrip && MoveToWindow (hGrip)) then
UtilitySayInfo(hGrip, FALSE) ;produces the requested output
else
	Say (msg358, ot_message) ;"Child window not found"
endif
EndScript

;Move up one level
Script  UtilityMoveToParent()
;{homerow+shift+f2}
var
	HANDLE hGrip
Let hGrip = GetParent(GetCurrentWindow ())
if  (hGrip && MoveToWindow (hGrip)) then
UtilitySayInfo(hGrip, FALSE) ;produces the requested output
else
	Say (msg359, ot_message) ;"Parent window not found"
endif
EndScript

;Adjust UT_OutputMode
Script UtilitySetOutputMode ()
;{homerow+f3}
If UT_OutputMode == UT_REALNAME then
	Let UT_OutputMode = UT_SAYTYPEANDTEXT
Else
	Let UT_OutputMode = UT_OutputMode + 1
EndIf
PerformScript UtilitySayOutputMode ()
EndScript

;Thanks to John Squally for writing the UtiltitySayOutputMode and
;UtilitySetOutputModeReverseOrder scripts as part of his participation
;in a Henter-Joyce script writing workshop.
Script UtilitySetOutputModeReverseOrder ()
;{Homerow+Shift+F3}
If UT_OutputMode == UT_SAYTYPEANDTEXT then
	Let UT_OutputMode = UT_REALNAME
Else
	Let UT_OutputMode = UT_OutputMode - 1
EndIf
PerformScript UtilitySayOutputMode ()
EndScript

Script UtilitySayOutputMode ()
If UT_OutputMode == UT_SAYTYPEANDTEXT then
	Say (msg360b, ot_message) ;"Say Type and Text"
EndIf
If UT_OutputMode == UT_FOCUS then
	Say (msg360, ot_message) ;"focus"
EndIf
If UT_OutputMode == UT_CONTROLID then
	Say (msg361, ot_message) ;"control i d"
EndIf
If UT_OutputMode == UT_CLASS then
	Say (msg362, ot_message) ;"Class"
EndIf
If UT_OutputMode == UT_TYPE then
	Say (msg363, ot_message) ;"Type"
EndIf
If UT_OutputMode == UT_SUBTYPE then
	Say (msg364, ot_message) ;"Sub type code"
EndIf
If UT_OutputMode == UT_REALNAME then
	Say (msg365, ot_message) ;"Real name"
EndIf
EndScript

;Adjust UT_FontMode
Script  UtilitySetFontMode()
;{homerow+f4}
If (UT_FontMode == 0 ) then
	Let UT_FontMode = ATTRIB_HIGHLIGHT
EndIf
If UT_FontMode == ATTRIB_HIGHLIGHT then
	Let UT_FontMode = ATTRIB_BOLD
Else
	If UT_FontMode == ATTRIB_STRIKEOUT then
		Let UT_FontMode = UT_FontMode * 4
	Else
		Let UT_FontMode = UT_FontMode * 2
	EndIf
EndIf
If UT_FontMode == ATTRIB_BOLD then
	Say (msg366, ot_message) ;"Bold"
EndIf
If UT_FontMode == ATTRIB_ITALIC then
	Say (msg367, ot_message) ;"Italic"
EndIf
If UT_FontMode == ATTRIB_UNDERLINE then
	Say (msg368, ot_message) ;"Underline"
EndIf
If UT_FontMode == ATTRIB_HIGHLIGHT then
	Say (msg369, ot_message) ;"Highlight"
EndIf
If UT_FontMode == ATTRIB_STRIKEOUT then
	Say (msg370, ot_message) ;"Strikeout"
EndIf
EndScript

;Called by utilities to speak the requested information
Void Function UtilitySayInfo (handle hGrip, int bSpellMode)
If (UT_OutputMode == UT_SAYTYPEANDTEXT) then
	SayWindowTypeAndText (hGrip)
EndIf
If (UT_OutputMode == UT_FOCUS) then
	SayInteger (hGrip)
EndIf
If (UT_OutputMode == UT_CONTROLID) then
	SayInteger (GetControlID (hGrip))
EndIf
If (UT_OutputMode == UT_CLASS) then
	If (bSpellMode) then
		SpellString (GetWindowClass (hGrip))
	Else
		Say (GetWindowClass (hGrip), ot_window_information)
	EndIf
EndIf
If (UT_OutputMode == UT_TYPE) then
	If (bSpellMode) then
		SpellString (GetWindowType (hGrip))
	Else
		Say (GetWindowType (hGrip), ot_window_information)
	EndIf
EndIf
If (UT_OutputMode == UT_SUBTYPE) then
		SayInteger (GetWindowSubTypeCode (hGrip))
EndIf
If (UT_OutputMode == UT_REALNAME) then
	If (bSpellMode) then
		SpellString (GetWindowName (GetRealWindow (hGrip)))
	Else
		Say (GetWindowName (GetRealWindow (hGrip)), ot_Window_information)
	EndIf
EndIf
EndFunction

Script  UtilitySayPrompt()
;{homerow + P}
SayControl (GetPriorWindow (GetCurrentWindow ()))
EndScript

Script UtilityResetOutputMode ()
Say (msg434, ot_message) ; "output mode is"
Let UT_OutputMode = UT_SAYTYPEANDTEXT
Say (msg360b, ot_message) ;"Say Type and Text"
EndScript

;Set Handle to first visible child window
Function UtilitySetHandleToFirstVisible (handle hGrip)
var  int safety
let safety = 0
while ((GetPriorWindow (hGrip)) && (Safety < 100))
	let hGrip = GetPriorWindow (hGrip)
	let Safety = Safety + 1
endwhile
while (IsWindowVisible (hGrip) == FALSE)
	let hGrip = GetNextWindow (hGrip)
endwhile
EndFunction

;Set handle to last visible child window
Void Function UtilitySetHandleToLastVisible (handle hGrip)
;{homerow+alt+control+tab}
var
	int safety
	let safety = 0
while ((GetNextWindow (hGrip)) && (Safety < 100))
	let hGrip = GetNextWindow (hGrip)
	let Safety = Safety + 1
endwhile
while (IsWindowVisible (hGrip) == FALSE)
	let hGrip = GetPriorWindow (hGrip)
endwhile
EndFunction

Script  SayFrame(string FrameName)
SayFrame (FrameName)
EndScript

Script  SayFrameAtCursor()
SayFrameAtCursor ()
EndScript

Void Function ScriptAndAppNames (string sFileName)
var
string theString

let theString = sFileName
If (GetVerbosity() == beginner) Then
	let theString = theString + msg374 ;" settings are loaded"
else
	let theString = theString + msg374b ; " settings"
endif
Say (theString, ot_help)
If(GetVerbosity() == beginner) Then
	Say (msg376, ot_help) ;"The application currently being used is the "
EndIf
Say (GetAppFileName (), ot_help)
SpellString (GetAppFileName ())
EndFunction



Script ClearValues()
FrameClearValues ()
DragAndDropClearValues ()
BrailleSelectTextClearValues ()
Say (msg437, ot_message) ; "Values Cleared"
EndScript

;**********************************
;     Extended Key Scripts  *
;**********************************

Script  SayNextCharacterPCCursor()
SaveCursor ()
PcCursor ()
PerformScript SayNextCharacter()
EndScript

Script  SayPriorCharacterPCCursor()
SaveCursor ()
PcCursor ()
PerformScript SayPriorCharacter()
EndScript

Script  SayNextLinePCCursor()
SaveCursor ()
PcCursor ()
PerformScript SayNextLine()
EndScript

Script  SayPriorLinePCCursor()
SaveCursor ()
PcCursor ()
PerformScript SayPriorLine()
EndScript

Script  SayNextWordPCCursor()
SaveCursor ()
PcCursor ()
PerformScript SayNextWord()
EndScript

Script  SayPriorWordPCCursor()
SaveCursor ()
PcCursor ()
PerformScript SayPriorWord()
EndScript

Script  ControlDownArrowPCCursor()
SaveCursor ()
PcCursor ()
PerformScript ControlDownArrow()
EndScript

Script  ControlUpArrowPCCursor()
SaveCursor ()
PcCursor ()
PerformScript ControlUpArrow()
EndScript

;*************************
;     Braille Scripts         *
;*************************



Script BrailleToggleMode ()
if (GetBrailleMode() == BRL_MODE_LINE) then
	SetBrailleMode(BRL_MODE_STRUCTURED)
	Say (msg438, ot_message) ; "Structured Mode"
	return
EndIf
if (GetBrailleMode() == BRL_MODE_attrib) then
	SetBrailleMode(BRL_MODE_STRUCTURED)
	Say (msg438, ot_message) ; "Structured Mode"
	return
EndIf
if (GetBrailleMode() == BRL_MODE_STRUCTURED) then
	SetBrailleMode(BRL_MODE_speechbox)
	Say (msg483, ot_message) ; "Speech Box Mode"
	return
EndIf
if (GetBrailleMode() == BRL_MODE_speechbox) then
	SetBrailleMode(BRL_MODE_line)
	if GlobalPixelsPerSpace then
		SetJCFOption(OPT_PIXELS_PER_SPACE, GlobalPixelsPerSpace)
	EndIf
	if GetJcfOption (OPT_BRL_AUTO_ROUTE_TO_CURSOR) == 1 then
		RouteBrailleToPc()
	EndIf
	Say (msg439, ot_message) ; "Line Mode"
EndIf
EndScript

Script BrailleGrade2Translation ()
if GetJCFOption (OPT_BRL_G2TRANSLATION) == 1 then
	SetDefaultJcfOption (OPT_BRL_G2TRANSLATION, 0)
	Say (msg502, ot_message); "Grade two translation off "
else
	SetDefaultJcfOption (OPT_BRL_G2TRANSLATION, 1)
	Say (msg501, ot_message); "Grade two translation on ",
EndIf
EndScript

Script BrailleGrade2ExpandCurrentWord ()
if GetJCFOption (OPT_BRL_G2EXPAND_CURRENT_WORD) == 1 then
	SetDefaultJcfOption (OPT_BRL_G2EXPAND_CURRENT_WORD, 0)
	Say (msg504, ot_message); "Translating whole line ",
else
	SetDefaultJcfOption (OPT_BRL_G2EXPAND_CURRENT_WORD, 1)
	Say (msg503, ot_message); "Expanding current word ",
EndIf
EndScript

Script BrailleMovesActive ()
if (GetJcfOption (OPT_BRL_MOVE_ACTIVE_CURSOR) == 1) then
	SetDefaultJcfOption (OPT_BRL_MOVE_ACTIVE_CURSOR, 0)
	Say (msg448, ot_message) ; "The active cursor will not follow the Braille cursor"
else
	SetDefaultJcfOption (OPT_BRL_MOVE_ACTIVE_CURSOR, 1)
	Say (msg449, ot_message) ; "The active cursor will follow the Braille cursor"
endIf
EndScript

Script ActiveMovesBraille ()
; Determins wether or not the braille display follows the active cursor
if (GetJcfOption (OPT_BRL_AUTO_ROUTE_TO_CURSOR) == 1) then
	SetDefaultJcfOption (OPT_BRL_AUTO_ROUTE_TO_CURSOR, 0)
	Say (msg451, ot_message) ; "The active cursor will not move the Braille cursor"
else
	SetDefaultJcfOption (	OPT_BRL_AUTO_ROUTE_TO_CURSOR, 1)
	Say (msg452, ot_message) ; "The active cursor will move the Braille cursor"
	beep()
endIf
EndScript

Script BrailleToggleCharactersAndAttributes()
if (GetBrailleMode() == BRL_MODE_LINE) then
	SetBrailleMode (BRL_MODE_attrib)
	Say (msg440, ot_message) ; "Attributes"
	return
EndIf
if (GetBrailleMode() == BRL_MODE_attrib) then
	SetBrailleMode (BRL_MODE_line)
	Say (msg441, ot_message) ; "characters"
	return
EndIf
SetBrailleMode (BRL_MODE_line)
Say (msg439, ot_message) ; "Line Mode"
EndScript

Script BrailleTab()
{Tab}
EndScript

Script BrailleShiftTab ()
{Shift+Tab}
EndScript

Script BrailleEnter()
{Enter}
EndScript

Script BrailleEscape()
{Esc}
EndScript
Script BrailleToggleCursor()
; Toggle between the JAWS and PC cursor
if (IsPCCursor ()) then
	PerformScript JawsCursor ()
else
	PerformScript PCCursor ()
EndIf
EndScript

Script BrailleAltTab ()
{Alt + Tab}
EndScript

Script BraillePriorLine ()
if (GetBrailleMode() == BRL_MODE_SPEECHBOX) then
	PriorBrailleString()
ElIf BrailleIsStructuredLine () then
	PriorLine ()
else
	BraillePriorLine()
EndIf
EndScript

Script BrailleNextLine ()
if (GetBrailleMode () == BRL_MODE_SPEECHBOX) then
	NextBrailleString ()
elif BrailleIsStructuredLine () then
	NextLine ()
else
	BrailleNextLine ()
EndIf
EndScript

Script BraillePanLeft()
; If there is more text to the left on the current line, display it.
; If not, display the final segment of the previous line.
if not BraillePanLeft () then
	if (GetBrailleMode() == BRL_MODE_Speechbox) then
		if (PriorBrailleString ()) then
			while (BraillePanRight ())
			endwhile
		endif
	ElIf not BrailleIsStructuredLine() then
		if BraillePriorLine () 
 then if !(GetWindowsOS ()==	OS_WIN_NT)			
then beep()
endif
			while (BraillePanRight() )
			endwhile
		EndIf
	EndIf
EndIf
EndScript

Script BraillePanRight ()
; If there is more text on the current line, then display it.
; Otherwise, display the first segment of the next line.
if not BraillePanRight () then
	if (GetBrailleMode() == BRL_MODE_SPEECHBOX) then
		if (NextBrailleString()) then
			while (BraillePanLeft())
			endwhile
		endif
	elif not BrailleIsStructuredLine () then
		if BrailleNextLine () 
 then	if !(GetWindowsOS ()==	OS_WIN_NT)
then		beep()
endif
			while (BraillePanLeft())
			endwhile
			BrailleLine ()
		EndIf
	EndIf
EndIf
EndScript

Script BrailleMoveLeft ()
if (GetJcfOption(OPT_Brl_Move_Active_Cursor) == 0) Then
	SaveCursor()
	BrailleCursor()
endif
if not BraillePanLeft() then
Beep()
endif
EndScript

Script BrailleMoveRight ()
if (GetJcfOption(Opt_Brl_Move_Active_Cursor) == 0) Then
	SaveCursor()
	BrailleCursor()
endif
if not BraillePanRIGHT() then
Beep()
endif
EndScript

Script BrailleToggle8PixelsPerSpace ()
If (GetJcfOption(Opt_Pixels_Per_Space) == 999) Then  ; Current setting is unlimited
  PerformScript BrailleSet8PixelsPerSpace()
Else
  PerformScript BrailleSetUnlimittedPixelsPerSpace()
EndIf
EndScript
Script BrailleRouting()
var
	int nX,
	int nY,
	int nCell
let nCell = GetLastBrailleRoutingKey ()
let nX = GetBrailleCellColumn (nCell)
let nY = GetBrailleCellRow (nCell)
if IsVirtualPCCursor () &&
GetWindowClass (GetFocus ())=="internet Explorer_server"
then LeftMouseButton ()
Return
endif
if (nY == 0) then
	return
EndIf
if (GetJcfOption(OPT_BRL_MOVE_ACTIVE_CURSOR) == 0) then
	SaveCursor ()
	BrailleCursor ()
	MoveTo (nX,nY)
	RestoreCursor()
if  (IsSameScript()) then
		RouteJAWSToBraille ()
		LeftMouseButton()
LeftMouseButton()
return
EndIf
	if IsPCCursor () then
		RoutePCToBraille ()
	elif IsJawsCursor () then
		RouteJAWSToBraille ()
		LeftMouseButton()
	else
	EndIf
else
	MoveTo (nX,nY)
EndIf
EndScript


Void Function BrailleBuildMenu ()
var
	int WindowSubTypeCode
if GetJcfOption (OPT_BRL_verbosity) < 2 then
	if (GetMenuMode () == MENUBAR_ACTIVE) then
		BrailleAddString (msg56,0,0,0) ; "Menu bar"
		BrailleAddFocusLine ()
		return TRUE
	ElIf (GetMenuMode () == MENU_ACTIVE) then
		let WindowSubTypeCode = GetWindowSubTypeCode(GetCurrentWindow())
		if WindowSubTypeCode == WT_STARTMENU then
			BrailleAddString (msg4,0,0,0) ; "Start menu"
		ElIf WindowSubTypeCode == WT_CONTEXTMENU then
			BrailleAddString (msg5,0,0,0) ; "Context menu"
		else
			BrailleAddString (GetMenuName () + msg445,0,0,0) ; " menu"
		EndIf
		BrailleAddFocusLine ()
		return TRUE
	EndIf
else
	BrailleAddFocusLine ()
	return TRUE
EndIf
EndFunction

Function BrailleBuildDialog (handle hwndReal)
var
	string Buffer,
	string CheckedUnchecked
let Buffer = GetWindowName (hwndReal) ; title of the dialog box
if GetJcfOption (OPT_BRL_Verbosity)==0  then
 if (buffer != msgNull) then ; there is a title
 BrailleAddString(buffer + msg493,0,0,0)
 endif
 let buffer = GetDialogPageName()
 if (buffer != msgNull) then ; there is a page name
 BrailleAddString(buffer + msg494,0,0,0)
 endif
 let buffer = GetDialogStaticText()
 if (buffer != msgNull) then ; there is static text in dialog
 BrailleAddString(buffer + " ",0,0,0)
 endif
 let buffer = GetGroupBoxName()
 if (buffer != msgNull) then ; there is a GroupBox name
 BrailleAddString(buffer + msg495,0,0,0)
 endif
 if ControlCanBeChecked () then
 if (ControlIsChecked ()) then
 let CheckedUnchecked = msgBrailleChecked
 else
 let CheckedUnchecked = msgBrailleUnChecked
 endif
 else
 let CheckedUnchecked = msgNull
 endif
 let buffer = GetControlName()
 if (buffer != msgNull) &
 (GetWindowTypeCode(GetFocus()) == WT_RADIOBUTTON ||
 GetWindowTypeCode(GetFocus()) == WT_CHECKBOX) then
 BrailleAddString (CheckedUnchecked+buffer + " " +GetWindowType(GetFocus()),
GetCursorCol (), GetCursorRow (), 32)
 elif GetWindowTypeCode (GetFocus ()) ==WT_BUTTON
then BrailleAddString (buffer+" "+msg496, GetCursorCol (), GetCursorRow (), 0)
Return TRUE
elif (GetWindowTypeCode(GetFocus()) == WT_EDIT ||
 GetWindowTypeCode(GetFocus()) == WT_COMBOBOX ||
 GetWindowTypeCode(GetFocus()) == WT_ListBOX ||
GetWindowTypeCode(GetFocus()) == WT_LISTVIEW  ||
 GetWindowTypeCode(GetFocus()) == WT_TREEVIEW)
then
BrailleAddString (buffer+" "+GetWindowType (GetFocus ()), 0, 0, 0)
 BrailleAddFocusItem()
  Return TRUE
 endif
; end beginner verbosity
elif  GetJcfOption (OPT_BRL_Verbosity)==1 then
 if (buffer != msgNull) then ; there is a title
 BrailleAddString(buffer + "_",0,0,0)
 endif
 let buffer = GetDialogPageName()
 if (buffer != msgNull) then ; there is a page name
 BrailleAddString(buffer + "_",0,0,0)
 endif
 let buffer = GetDialogStaticText()
 if (buffer != msgNull) then ; there is static text in dialog
 BrailleAddString(buffer + " ",0,0,0)
 endif
 let buffer = GetGroupBoxName()
 if (buffer != msgNull) then ; there is a GroupBox name
 BrailleAddString(buffer + "_",0,0,0)
 endif
 if ControlCanBeChecked () then
 if  (ControlIsChecked ()) then
 let CheckedUnchecked = msgBrailleChecked
 else
 let CheckedUnchecked = msgBrailleUnChecked
 endif
 else
 let CheckedUnchecked = msgNull
 endif
 let buffer = GetControlName()
 if (buffer != msgNull) &
 (GetWindowTypeCode(GetFocus()) == WT_RADIOBUTTON ||
 GetWindowTypeCode(GetFocus()) == WT_CHECKBOX) then
 BrailleAddString (CheckedUnchecked+buffer + " " ,
GetCursorCol (), GetCursorRow (), 32)
 elif GetWindowTypeCode (GetFocus ()) ==WT_BUTTON
then BrailleAddString (buffer+" "+msg496, GetCursorCol (), GetCursorRow (), 0)
Return TRUE
elif (GetWindowTypeCode(GetFocus()) == WT_EDIT ||
 GetWindowTypeCode(GetFocus()) == WT_COMBOBOX ||
 GetWindowTypeCode(GetFocus()) == WT_ListBOX ||
GetWindowTypeCode(GetFocus()) == WT_LISTVIEW  ||
 GetWindowTypeCode(GetFocus()) == WT_TREEVIEW)
then
BrailleAddString (buffer, 0, 0, 0)
 BrailleAddFocusItem()
  Return TRUE
 endif
; end intermediate verbosity
elif GetJcfOption (OPT_BRL_verbosity)==2  then
 if ControlCanBeChecked () then
 if  (ControlIsChecked ()) then
 let CheckedUnchecked = msgBrailleChecked
 else
 let CheckedUnchecked = msgBrailleUnChecked
 endif
 else
 let CheckedUnchecked = msgNull
 endif
 let buffer = GetControlName()
 if (buffer != msgNull) &
 (GetWindowTypeCode(GetFocus()) == WT_RADIOBUTTON ||
 GetWindowTypeCode(GetFocus()) == WT_CHECKBOX) then
 BrailleAddString (CheckedUnchecked+buffer + " " ,
GetCursorCol (), GetCursorRow (), 32)
 elif GetWindowTypeCode (GetFocus ()) ==WT_BUTTON
then BrailleAddString (buffer, GetCursorCol (), GetCursorRow (), 0)
Return TRUE
elif (GetWindowTypeCode(GetFocus()) == WT_EDIT ||
 GetWindowTypeCode(GetFocus()) == WT_COMBOBOX ||
 GetWindowTypeCode(GetFocus()) == WT_ListBOX ||
GetWindowTypeCode(GetFocus()) == WT_LISTVIEW  ||
 GetWindowTypeCode(GetFocus()) == WT_TREEVIEW)
then
BrailleAddString (GetControlName (), 0, 0, 0)
 BrailleAddFocusItem()
  Return TRUE
 endif
endif
EndFunction

Void Function BrailleBuildOther (int WindowSubTypeCode)
var
	string Buffer
if WindowSubTypeCode == 	WT_DESKTOP then
	BrailleAddString (msg446,0,0,0) ; "Desktop"
	BrailleAddFocusItem ()
	return TRUE
elif WindowSubTypeCode == WT_TASKBAR then
	BrailleAddString (msg447,0,0,0) ; "Task Bar"
	BrailleAddFocusLine()
	return TRUE
elif WindowSubTypeCode == WT_STARTBUTTON then
	BrailleAddFocusItem()
	return TRUE
elif WindowSubTypeCode == WT_COMBOBOX ||
	WindowSubTypeCode == WT_ListBOX ||
	WindowSubTypeCode == WT_LISTVIEW ||
	WindowSubTypeCode ==	WT_EXTENDEDSELECT_LISTBOX ||
	WindowSubTypeCode == WT_TREEVIEW ||
	WindowSubTypeCode == WT_button then
	if GetJcfOption (OPT_BRL_Verbosity)==0 then
		let Buffer = GetWindowType (GetFocus ())
		BrailleAddString (Buffer, 0, 0, 0)
	EndIf
	BrailleAddFocusItem()
	return TRUE
else
	return FALSE
EndIf
EndFunction

Void Function BrailleBuildLine ()
var
	handle hwnd,
	int WindowTypeCode
if MenusActive () then
	if !GlobalPixelsPerSpace then
		let GlobalPixelsPerSpace=GetJcfOption (OPT_PIXELS_PER_SPACE)
	EndIf
	SetJcfOption (OPT_PIXELS_PER_SPACE, 99)
	BrailleBuildMenu()
	Return TRUE
EndIf
let hwnd = GetFocus()
let WindowTypeCode = GetWindowSubTypeCode (hwnd)
if DialogActive () then
	if !GlobalPixelsPerSpace then
		let GlobalPixelsPerSpace=GetJcfOption (OPT_PIXELS_PER_SPACE)
	EndIf
	SetJcfOption (OPT_PIXELS_PER_SPACE, 99)
	BrailleBuildDialog(GetRealWindow(hwnd))
	return TRUE
EndIf
if WindowTypeCode == WT_LISTVIEW ||
WindowTypeCode == WT_LISTBOX ||
WindowTypeCode == WT_TREEVIEW ||
WindowTypeCode == WT_STARTBUTTON ||
WindowTypeCode == WT_DESKTOP ||
WindowTypeCode == WT_TASKBAR
then
	if !GlobalPixelsPerSpace then
		let GlobalPixelsPerSpace=GetJcfOption (OPT_PIXELS_PER_SPACE)
	EndIf
	SetJcfOption (OPT_PIXELS_PER_SPACE, 99)
	BrailleBuildOther(WindowTypeCode)
	Return TRUE
EndIf
if GlobalPixelsPerSpace then
	SetJcfOption (OPT_PIXELS_PER_SPACE, GlobalPixelsPerSpace)
EndIf
let GlobalPixelsPerSpace = 0
return FALSE
EndFunction

Script BrailleTop ()
if not BrailleIsStructuredLine () then
	SaveCursor ()
	BrailleCursor ()
	RouteBrailleToPC ()
	JAWSPageUp ()
	JAWSHome ()
	Say (msg52, ot_message) ; "top of window"
else
	while (BraillePanLeft ())
	EndWhile
	Say (msg484, ot_message) ; "Beginning of line"
EndIf
EndScript

Script BrailleBottom ()
if not BrailleIsStructuredLine () then
	SaveCursor ()
	BrailleCursor ()
	RouteBrailleToPC ()
	JAWSPageDown ()
	JAWSEnd ()
	Say (msg54, ot_message) ; "bottom of window"
else
	while (BraillePanright ())
	EndWhile
	Say (msg485, ot_message) ; "End of line"
EndIf
EndScript

Script BrailleSet8PixelsPerSpace()
Say (msg390, ot_message) ;"8 pixels per space"
SetJcfOption(OPT_PIXELS_PER_SPACE,8)
EndScript

Script BrailleSetUnlimittedPixelsPerSpace()
Say (msg391, ot_message) ;"Unlimitted pixels per space"
SetJcfOption(OPT_PIXELS_PER_SPACE,999)
EndScript

Script BrailleToggleMarking()
var
	int markingNow
let markingNow = GetJcfOption(OPTBRL_MARKING)
if (markingNow >= BRL_MARKING_ALL) then
	let markingNow = BRL_MARKING_NONE
else
	let markingNow = markingNow+1
endif
SetJcfOption(OPTBRL_MARKING,markingNow)
if (markingNow == BRL_MARKING_NONE) then
	Say (msg392, ot_message) ;"Braille marking off"
	return
endif
if (markingNow == BRL_MARKING_HIGHLIGHT) then
	Say (msg393, ot_message) ;"Braille marking  highlight"
	return
endif
if (markingNow == BRL_MARKING_BOLD) then
	Say (msg394, ot_message)  ;"Braille marking  bold"
	return
endif
if (markingNow == BRL_MARKING_UNDERLINE) then
	Say (msg395, ot_message) ; "Braille marking  underline"
	return
endif
if (markingNow == BRL_MARKING_ITALIC) then
	Say (msg396, ot_message) ; "Braille marking  italic"
	return
endif
if (markingNow == BRL_MARKING_STRIKEOUT) then
	Say (msg397, ot_message) ; "Braille marking  strike out"
	return
endif
if (markingNow == BRL_MARKING_ALL) then
	Say (msg398, ot_message) ; "Braille marking all "
	return
endif
EndScript

Script  BrailleTurnMarkingOff()
SetJcfOption (OPTBRL_MARKING, BRL_MARKING_NONE)
Say (msg392, ot_message) ;"Braille marking off"
EndScript

script BrailleDescribeFont()
var
	int nX,
	int nY,
	int nCell
let nCell = GetLastBrailleRoutingKey()
if (nCell > 0) then
	let nX = GetBrailleCellColumn(nCell)
	let nY = GetBrailleCellRow(nCell)
	SaveCursor()
	InvisibleCursor()
	MoveTo(nX,nY)
	SayFont()
	RestoreCursor()
EndIf
EndScript

Script  BrailleToggle8Dots()
var
	int EightDot
let EightDot = GetJcfOption (OPTBRL_EIGHT_DOT)
if (EightDot) then
	SetJcfOption (OPTBRL_EIGHT_DOT, FALSE)
	Say (msg399, ot_message) ;"six dot braille"
else
	SetJcfOption (OPTBRL_EIGHT_DOT, TRUE)
	Say (msg400, ot_message) ;"eight dot braille"
Endif
EndScript

Script  BrailleSet6Dots()
SetJcfOption (OPTBRL_EIGHT_DOT, FALSE)
Say (msg399, ot_message) ;"six dot braille"
EndScript

Script BrailleSet8Dots()
SetJcfOption (OPTBRL_EIGHT_DOT, TRUE)
Say (msg400, ot_message) ;"eight dot braille"
EndScript

Script RouteBrailleToPC ()
RouteBrailleToPC ()
EndScript

Script RouteBrailleToJaws ()
RouteBrailleToJaws ()
EndScript

Script RouteBrailleToActiveCursor ()
var
	int ActiveCursor
let activeCursor = GetActiveCursor ()
if (ActiveCursor == cursor_jaws) then
	RouteBrailleToJaws ()
ElIf (ActiveCursor == cursor_pc) then
	RouteBrailleToPC ()
EndIf
EndScript


Script BrailleSelectText ()
var
int x,
int y
if (SelectSet == false) then
let SelectFromX = GetBrailleCellColumn (GetLastBrailleRoutingKey ())
let SelectFromY = GetBrailleCellRow (GetLastBrailleRoutingKey ())
let SelectSet = true
SaveCursor ()
BrailleCursor ()
MoveTo (SelectFromX, SelectFromY)
BrailleSetAllCursorsBlinkRate (0)
Say (msg486, ot_message) ; "Selecting Text"
return
EndIf
SaveCursor ()
let x = GetBrailleCellColumn (GetLastBrailleRoutingKey ())
let y = GetBrailleCellRow (GetLastBrailleRoutingKey ())
JawsCursor ()
; make sure that the left mouse button is unlocked
If IsLeftButtonDown () then
LeftMouseButtonLock ()
pause ()
EndIf
MoveTo (SelectFromX, SelectFromY)
Pause ()
LeftMouseButtonLock () ; lock it down
pause ()
MoveTo (x,y)
Pause ()
LeftMouseButtonLock ()
pause ()
RestoreCursor ()
BrailleSetAllCursorsBlinkRate (BrailleOldBlinkRate)
Let SelectSet = false
EndScript



Void Function BrailleSelectTextClearValues ()
if SelectSet then
	let SelectSet = false
	BrailleChangeCursorShape ()
EndIf
EndFunction
Script BrailleToggleSpeechBox ()
var
int Current_Braille_Mode
let Current_Braille_Mode = GetBrailleMode()
if (GetBrailleMode() == BRL_MODE_Line || GetBrailleMode() == BRL_MODE_Structured || GetBrailleMode() == BRL_MODE_Speechbox) then
	if (GetBrailleMode() != BRL_MODE_Speechbox) Then
		SetBrailleMode(BRL_MODE_Speechbox)
		Let Previous_Braille_Mode = Current_Braille_Mode
		Say (msg483, OT_STRING) ; Speech Box Mode
		return
	Else
    		SetBrailleMode(Previous_Braille_Mode)
		Say (msg554, OT_STRING); "Speech box mode off"
		return
	EndIf
Endif
EndScript

Script BrailleToggleBrailleLineMode ()
if (GetBrailleMode() != BRL_MODE_Line) then
	SetBrailleMode(BRL_MODE_Line)
	Say (msg439, OT_STRING)
	return
Else
Say (msg439, OT_STRING)
EndIf
EndScript

Script BrailleDescribeItem ()

var
int nX,
int nY,
int nCell,

handle TheWindow,
handle TheRealWindow,
handle	TheAppWindow,
int 	TheType,
int 	TheRealType,
string 	String1,
string 	TheChunk,
string	TheLine,
string	TheMenu,
int 	MenuItem,
;int	MenuBar,
String	ThePageName,
int	IsDialogTabPage,
int	HasPrompt,
string	TheControlName,
int	PromptSelected,
string	TheGroupBoxName,
handle TheGroupBox,
string	TheWord,
string	TheCharacter

let nCell = GetLastBrailleRoutingKey()
If (nCell>200) then
	Let nCell=NCell-200
EndIf
let nX = GetBrailleCellColumn(nCell)
let nY = GetBrailleCellRow(nCell)
if (nY == 0) then
	return
endif

SaveCursor()
InvisibleCursor ()
MoveTo(nX,nY)

let TheWindow=GetCurrentWindow ()
let TheChunk=GetChunk ()
let TheWord=GetWord()
Let TheCharacter=GetCharacter()
let TheLine=GetLine ()
let TheMenu=GetMenuName ()
Let ThePageName=GetDialogPageName ()
Let IsDialogTabPage=IsMultiPageDialog ()
;Let TheGroupBoxName=GetGroupBoxName ()
If (GetWindowSubTypeCode (TheWindow)==WT_UNKNOWN)  then
	if ((GetWindowClass (TheWindow)=="Opuswwd") ||(GetWindowClass (TheWindow)=="_WwG"))then
	;We are in MS-Word
		Say (TheWord, OT_STRING)
		Say (TheCharacter, OT_STRING)
		Saycolor()
		PerformScript SayFont ()
	else
		SayChunk()
		Say (Msg532, OT_STRING);"This is an unknown window type"

			SayFont ()
			SayColor ()
		endif
return
EndIf

RestoreCursor()

Let TheType=GetWindowSubTypeCode (TheWindow)
Let TheRealWindow=GetRealWindow(TheWindow)
Let TheRealType=GetWindowTypeCode(TheRealWindow)

If ((GetVerbosity ()==BEGINNER) &&
	(TheType!=WT_TOOLBAR)&&(TheType!=WT_HEADERBAR)&&(TheType!=WT_STATUSBAR)&&
	(TheType!=WT_SPINBOX)&&(TheType!=WT_DIALOG)&&(TheType!=WT_CHECKBOX)&&
	(TheType!=WT_GROUPBOX)&&(TheType!=WT_3STATE)&&(TheType!=WT_LEFTRIGHTSLIDER)&&
	(TheType!=WT_UPDOWNSLIDER)&&(TheType!=WT_COMMANDBAR))Then
	Say (Msg520, OT_STRING);"This is "

Endif

If (TheType==WT_STATIC)  then
;check if it's not some prompt
	If ( GetWindowName (GetNextWindow (TheWindow))==TheChunk) Then
		SaveCursor()
		InvisibleCursor ()
		MoveToWindow (GetNextWindow (TheWindow))
		let TheWindow=GetCurrentWindow ()
		let TheChunk= msgNull
		RestoreCursor()
		Say (Msg521, OT_STRING);"Prompt text to ",
		Let TheType=GetWindowTypeCode (TheWindow)
		Let PromptSelected=TRUE
	Else
		Say (wc291, OT_STRING);"static text"
	Endif
Endif

If (TheType==WT_BUTTON)  then
	Say (wc290, OT_STRING);"Button"
ElIf (TheType==WT_COMBOBOX)  then
	If Not (TheChunk==msgNull) Then
		Say (Msg522, OT_STRING);"Item "
	EndIf
	Let HasPrompt=TRUE
ElIf (TheType==WT_EDIT)  then
	If Not (TheChunk==msgNull) Then
		Say (Msg523, OT_STRING);"Text "
	EndIf
	Let HasPrompt=TRUE
ElIf (TheType==WT_LISTBOX)  then
	If Not (TheChunk==msgNull) Then
		Say (Msg522, OT_STRING);"Item "
	EndIf
	Let HasPrompt=TRUE
ElIf (TheType==WT_SCROLLBAR)  then
	Let HasPrompt=TRUE
ElIf (TheType==WT_TOOLBAR)  then
	SaveCursor()
	InvisibleCursor ()
	MoveToGraphic (GRAPHIC_PRIOR)
	MoveToGraphic (GRAPHIC_NEXT)
	let TheChunk=GetChunk ()
	RestoreCursor()
	Say (msg139+wc290, OT_STRING);"this is a tool bar"+"Button"
ElIf (TheType==WT_STATUSBAR)  then
	Say (msg143, OT_STRING);"This is an application status bar"
ElIf (TheType==WT_HEADERBAR)  then
	Say (msg146, OT_STRING);"This is a header bar"
ElIf (TheType==WT_BUTTONLISTBOX)  then
	Let HasPrompt=TRUE
ElIf (TheType==WT_SLIDER)  then
	Say (Msg525, OT_STRING);	"Minimized Window"
	Let HasPrompt=TRUE
ElIf (TheType==WT_SPINBOX)  then
	Say (Msg150, OT_STRING);"This is a spin box"
	Let HasPrompt=TRUE
ElIf (TheType==WT_MENU)  then
	Say (msg445+Msg522, OT_STRING);" menu"+"Item "
	Let MenuItem=TRUE
;WT_DESKTOP not implemented
;WT_WINSWITCH not implemented
ElIf (TheType==WT_ICONTITLE)  then
	Say (Msg525, OT_STRING);"Minimized Window"
;WT_MDICLIENT not implemented
ElIf (TheType==WT_DIALOG)  then
	Say (Msg163, OT_STRING);"This is a dialog box"
	Say (GetWindowName (TheWindow), OT_STRING)
	Let TheChunk=msgNull
ElIf (TheType==WT_RADIOBUTTON)  then
	Say (Msg526, OT_STRING);"RadioButton "
	Let TheChunk=GetWindowName (TheWindow)
;	Let HasPrompt=TRUE	 ; only if grouboxname can be retrieved
ElIf (TheType==WT_CHECKBOX)  then
	Say (Msg168, OT_STRING);"This is a check box"
	Let TheChunk=GetWindowName (TheWindow)
ElIf (TheType==WT_GROUPBOX)  then
	Say (msg171, OT_STRING);"This is a groupbox"
ElIf (TheType==WT_3STATE)  then
	Say (msg168, OT_STRING);"This is a check box"
ElIf (TheType==WT_SDM)  then
	Say (Msg163, OT_STRING);"This is a dialog box"
ElIf (TheType==WT_BITMAP)  then
	SaveCursor()
	InvisibleCursor ()
	MoveToGraphic (GRAPHIC_PRIOR)
	MoveToGraphic (GRAPHIC_NEXT)
	let TheChunk=GetChunk ()
	RestoreCursor()
	Say (Msg527, OT_STRING);"Bitmap "
ElIf (TheType==WT_HOTKEY)  then
	If Not (TheChunk==msgNull) Then
		Say (msg180, OT_STRING);"This is a hot key or short cut key edit control"
	EndIf
	Let HasPrompt=TRUE
ElIf (TheType==WT_TABCONTROL)  then
	Say (Msg529, OT_STRING);"Tab Control "
	Let IsDialogTabPage=FALSE
ElIf (TheType==WT_LISTVIEW)  then
	Say (Msg530, OT_STRING);"An Icon in a listview "
	Let TheChunk=msgNull
ElIf (TheType==WT_TREEVIEW)  then
	Say (Msg531, OT_STRING);"An item in a Tree view "
	Let TheChunk=msgNull
ElIf (TheType==WT_STARTBUTTON)  then
	Say (msg32, OT_STRING);"Start Button"
	Let TheChunk=msgNull
ElIf (TheType==WT_STARTMENU)  then
	Say (Msg4+Msg522, OT_STRING);"Start Menu"+"Item "
	Let TheChunk=TheLine
ElIf (TheType==WT_CONTEXTMENU)  then
	Say (Msg5+Msg522, OT_STRING);"Context Menu"+"Item "
	Let TheChunk=TheLine
ElIf (TheType==WT_TASKBAR)  then
	Say (Msg33+ wc290, OT_STRING);"TaskBar"+"Button"
;WT_MENUBAR not implemented
ElIf (TheType==WT_MULTISELECT_LISTBOX)  then
	Let TheType=WT_LISTBOX
	If Not (TheChunk==msgNull) Then
		Say (Msg522, OT_STRING);"Item "
	EndIf
	Let HasPrompt=TRUE
ElIf (TheType==WT_EXTENDEDSELECT_LISTBOX)  then
	Let TheType=WT_LISTBOX
	If Not (TheChunk==msgNull) Then
		Say (Msg522, OT_STRING);"Item "
	EndIf
	Let HasPrompt=TRUE
ElIf (TheType==WT_LEFTRIGHTSLIDER)  then
	Let TheType=WT_SLIDER
	Say (msg240, OT_STRING);"This is a horizontal slider"
	Let HasPrompt=TRUE
ElIf (TheType==WT_UPDOWNSLIDER)  then
	Let TheType=WT_SLIDER
	Say (msg244, OT_STRING);"This is a vertical slider"
	Let HasPrompt=TRUE
ElIf (TheType==WT_EDITCOMBO)  then
	If Not (TheChunk==msgNull) Then
		Say (Msg523, OT_STRING);"Text "
	EndIf
	Let HasPrompt=TRUE
ElIf (TheType==WT_PASSWORDEDIT)  then
	Let HasPrompt=TRUE
ElIf (TheType==WT_READONLYEDIT)  then
	If Not (TheChunk==msgNull) Then
		Say (Msg523, OT_STRING);"Text "
	EndIf
	Let HasPrompt=TRUE
ElIf (TheType==WT_COMMANDBAR)  then
	Say (Msg406, OT_STRING);"This is a command bar"
ElIf (TheType==WT_UPDOWNSCROLLBAR)  then
	Let HasPrompt=TRUE
	Let TheType=WT_SCROLLBAR
ElIf (TheType==WT_LEFTRIGHTSCROLLBAR)  then
	Let HasPrompt=TRUE
	Let TheType=WT_SCROLLBAR
EndIf




If (Not MenuItem ) then
	If ((TheType==WT_STATUSBAR)||(TheType==WT_HEADERBAR))  then
		;Do nothing because this probably gives to much spoken text
	Elif ((TheType==WT_SCROLLBAR)||(TheType==WT_SLIDER)||(TheType==WT_SPINBOX)) then
		;Do nothing because their should be an empty string in TheChunk
	Else
		Say (TheChunk+" ", OT_STRING)
	EndIf
	If (HasPrompt) Then
		If ((GetVerbosity ()==BEGINNER)&&(Not PromptSelected)&&(TheChunk!=msgNull)) Then
				Say (Msg528, OT_STRING);"In "
		EndIf
		Let TheControlName=GetWindowName (TheWindow)
		If (TheType==WT_COMBOBOX)  then
			Say (Msg533+TheControlName, OT_STRING);"Combobox "
		ElIf (TheType==WT_EDIT)  then
			Say (Msg534+TheControlName, OT_STRING);"Edit "
		ElIf (TheType==WT_PASSWORDEDIT)  then
			Say (Msg535+TheControlName, OT_STRING);"PassWord Edit "
		ElIf (TheType==WT_EDITCOMBO)  then
			Say (Msg536+TheControlName, OT_STRING);"Edit Combo"
		ElIf (TheType==WT_LISTBOX)  then
			Say (Msg537+TheControlName, OT_STRING);"Listbox "
		ElIf (TheType==WT_RADIOBUTTON)  then
		ElIf (TheType==WT_HOTKEY)  then
			Say (Msg539+TheControlName, OT_STRING);"HotKeyEdit "
		Else
			Say (TheControlName, OT_STRING)
		Endif
	EndIf ;(HasPrompt)
	If ((TheRealType==WT_DIALOG)&&(TheType!=WT_DIALOG)&&(TheChunk!=msgNull))then
			If (IsDialogTabPage) Then
				If (GetVerbosity ()==BEGINNER) Then
					Say (Msg540 + ThePageName+ " ", OT_STRING);"on tabpage"
				Else
					Say ( Msg541 + ThePageName+ " ", OT_STRING);"page "
				Endif
			EndIf
			If (GetVerbosity ()==BEGINNER) Then
				Say (Msg542 + GetWindowName (TheRealWindow)+ " ", OT_STRING);"in dialog window "
			Else
				Say ( Msg543 + GetWindowName (TheRealWindow)+ " ", OT_STRING);+"dialog "
			Endif
	Endif
Elif (MenuItem) then
	If (GetVerbosity ()==BEGINNER) Then
		Say (TheLine+Msg544+TheMenu+" ", OT_STRING);"from menu "
	Else
		Say (TheLine+Msg545+TheMenu+" ", OT_STRING);"menu "
	EndIf
Endif

Let TheAppWindow=GetAppMainWindow (TheWindow)
If Not (GetWindowName (TheAppWindow)==msgNull) Then
	If (GetVerbosity ()==BEGINNER) Then
		Say (Msg546 + GetWindowName (TheAppWindow), OT_STRING);"in application "
	Else
		Say (Msg547 + GetWindowName (TheAppWindow), OT_STRING);"application "
	Endif
EndIf


EndScript


Script BrailleRightMouseClick ()

var
int nX,
int nY,
int nCell

let nCell = GetLastBrailleRoutingKey()
If (nCell>200) then
	Let nCell=NCell-200
EndIf
let nX = GetBrailleCellColumn(nCell)
let nY = GetBrailleCellRow(nCell)
if (nY == 0) then
	return
endif

SaveCursor()
JAWSCursor ()

MoveTo(nX,nY)
RightMouseButton ()

RestoreCursor()
EndScript
Void Function BrailleSetAllCursorDots (string PcCursorDots, string JawsCursorDots, string InvisibleCursorDots)
SaveCursor()
PcCursor()
BrailleSetCursorDots (PcCursorDots)
JawsCursor()
BrailleSetCursorDots (JawsCursorDots)
InvisibleCursor()
BrailleSetCursorDots (InvisibleCursorDots)
RestoreCursor()
EndFunction

Void Function BrailleSaveAllCursorDots ()
SaveCursor()
PcCursor()
Let OldPcCursorDots = BrailleGetCursorDots()
JawsCursor()
Let OldJawsCursorDots = BrailleGetCursorDots()
InvisibleCursor()
Let OldInvisibleCursorDots = BrailleGetCursorDots()
RestoreCursor()
EndFunction


Void Function BrailleSetAllCursorsBlinkRate (int NewBlinkRate)
SaveCursor()
PcCursor()
SetDefaultJcfOption (optbrl_cursor_blink_rate, NewBlinkRate)
JawsCursor()
SetDefaultJcfOption (optbrl_cursor_blink_rate, NewBlinkRate)
InvisibleCursor()
SetDefaultJcfOption (optbrl_cursor_blink_rate, NewBlinkRate)
RestoreCursor()
EndFunction

Script BrailleChangeCursorShape ()
If (BrailleCursorShape == 0) Then
  Let BrailleCursorShape = BrailleCursorShape + 1
  BrailleSetAllCursorsBlinkRate(0)
  Return
ElIf (BrailleCursorShape == 1) Then
  Let BrailleCursorShape = BrailleCursorShape + 1
  BrailleSaveAllCursorDots()
  BrailleSetAllCursorDots("78", "78", "78")
  BrailleSetAllCursorsBlinkRate(500)
  Return
ElIf (BrailleCursorShape == 2) Then
  Let BrailleCursorShape = BrailleCursorShape + 1
  BrailleSetAllCursorsBlinkRate(0)
  Return
ElIf (BrailleCursorShape == 3) Then
  Let BrailleCursorShape = BrailleCursorShape + 1
  BrailleSetAllCursorDots("12345678", "12345678", "12345678")
  BrailleSetAllCursorsBlinkRate(500)
  Return
ElIf (BrailleCursorShape == 4) Then
  Let BrailleCursorShape = BrailleCursorShape + 1
  BrailleSetAllCursorsBlinkRate(0)
  Return
ElIf (BrailleCursorShape == 5) Then
  Let BrailleCursorShape = 0
  BrailleSetAllCursorDots(OldPcCursorDots, OldJawsCursorDots, OldInvisibleCursorDots)
  BrailleSetAllCursorsBlinkRate(BrailleOldBlinkRate)
EndIf
EndScript

Script BrailleLineCursorShapeOff ()
var
  int Current_Blink_Rate
Let Current_Blink_Rate=GetDefaultJcfOption(OptBrl_Cursor_Blink_Rate)
If (Current_Blink_Rate !=0-1) Then
  Let BrailleOldBlinkRate2 = GetDefaultJcfOption(OptBrl_Cursor_Blink_Rate)
		  BrailleSetAllCursorsBlinkRate(0-1)
Else
  BrailleSetAllCursorsBlinkRate (BrailleOldBlinkRate2)
EndIf
EndScript

; The following set of scripts are intended for Papenmeier  Braille Displays
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Start F.H. Papenmeier Scripts
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

Globals
  Int g_bBrailleCursorHidden,
  Int g_b2DPCMode,
  Int g_b2DReadingMode,
  String OldCursorDots  ; Used to store old Cursor value
;
;  Announcement for Switches and Toggles
;

Script FHPBraille2DTogglePCMode ()
	FHPBrailleUnhideBrailleCursor()
	let g_b2DReadingMode = 0
	if (g_b2DPCMode == 0) then
		let g_b2DPCMode = 1
		SayString("P C Mode")	
	else
		let g_b2DPCMode = 0
		SayString("Navigation Mode")	
	endif
EndScript


Script FHPBraille2DToggleReadingMode ()
	FHPBrailleUnhideBrailleCursor()
	let g_b2DPCMode = 0
	if (g_b2DReadingMode == 0) then
		let g_b2DReadingMode = 1
		SayString("Combined Mode")	
	else
		let g_b2DReadingMode = 0
		SayString("Navigation Mode")	
	endif
EndScript


Script FHPBrailleKeyPCMode ()
	FHPBrailleUnhideBrailleCursor()
	SayString("P C Mode")
EndScript


Script FHPBrailleKeyNavigationMode ()
	FHPBrailleUnhideBrailleCursor()
	SayString("Navigation Mode")
EndScript


Script FHPBrailleKeyReadingMode ()
	FHPBrailleUnhideBrailleCursor()
	SayString("Combined Mode")
EndScript


Script FHPBrailleKeySpeechMode ()
	FHPBrailleUnhideBrailleCursor()
	SayString("Speech Mode")
EndScript


Script FHPBrailleKeyBrailleMode ()
	FHPBrailleUnhideBrailleCursor()
	SayString("Braille Mode")
EndScript


Script FHPBrailleKeyBrailleSpeechMode ()
	FHPBrailleUnhideBrailleCursor()
	SayString("Switch has no function")
EndScript

; PC key simulation
; Braillex EL right switch in rear position = PC Mode

Script  FHPcursorup()
	FHPBrailleUnhideBrailleCursor()
	PerformScript SayPriorLine()
EndScript

Script  FHPcursordown()
	FHPBrailleUnhideBrailleCursor()
	PerformScript SayNextLine()
EndScript

Script  FHPcursorright()
	FHPBrailleUnhideBrailleCursor()
	PerformScript SayNextCharacter()
EndScript

Script  FHPcursorleft()
	FHPBrailleUnhideBrailleCursor()
	PerformScript SayPriorCharacter()
EndScript

Script FHPBrailleTab()
	FHPBrailleUnhideBrailleCursor()
	PerformScript BrailleTab()
EndScript

Script FHPBrailleShiftTab()
	FHPBrailleUnhideBrailleCursor()
	PerformScript BrailleShiftTab()
EndScript

Script FHPBrailleEscape()
	FHPBrailleUnhideBrailleCursor()
	PerformScript BrailleEscape()
EndScript

Script FHPBrailleEnter()
	FHPBrailleUnhideBrailleCursor()
	PerformScript BrailleEnter()
EndScript

;
; Navigation Mode
; Braillex EL right switch in central position
;
Script FHPBraillePriorLine()
	FHPBrailleUnhideBrailleCursor()

	if (g_b2DPCMode) then
		PerformScript  FHPcursorup()
		return
	endif
	if (g_b2DReadingMode) then
		PerformScript  FHPBrailleSpeechPriorLine()
		return
	endif
	PerformScript BraillePriorLine()
EndScript

Script FHPBrailleNextLine()
	FHPBrailleUnhideBrailleCursor()

	if (g_b2DPCMode) then
		PerformScript  FHPcursordown()
		return
	endif
	if (g_b2DReadingMode) then
		PerformScript  FHPBrailleSpeechNextLine()
		return
	endif

	PerformScript BrailleNextLine()
EndScript

Script FHPBraillePanLeft()
	FHPBrailleUnhideBrailleCursor()

	if (g_b2DPCMode) then
		PerformScript  FHPcursorleft()
		return
	endif
	if (g_b2DReadingMode) then
		PerformScript  FHPBrailleSpeechPanLeft()
		return
	endif

	PerformScript BraillePanLeft()
EndScript

Script FHPBraillePanRight()
	FHPBrailleUnhideBrailleCursor()

	if (g_b2DPCMode) then
		PerformScript  FHPcursorright()
		return
	endif
	if (g_b2DReadingMode) then
		PerformScript  FHPBrailleSpeechPanRight()
		return
	endif

	PerformScript BraillePanRight()
EndScript


;
; Combined Mode
; Braillex EL right key in front position
;

Script FHPBrailleSpeechPriorLine ()
	FHPBrailleUnhideBrailleCursor()
	PerformScript SayPriorLine()
EndScript

Script FHPBrailleSpeechNextLine ()
	FHPBrailleUnhideBrailleCursor()
	PerformScript SayNextLine()
EndScript

Script FHPBrailleSpeechPanLeft()
	FHPBrailleUnhideBrailleCursor()
	if (not BraillePanLeft()) then
		PerformScript SayPriorLine()
	endif
EndScript

Script FHPBrailleSpeechPanRight()
	FHPBrailleUnhideBrailleCursor()
	if (not BraillePanRight()) then
		PerformScript SayNextLine()
	endif
EndScript


;
; routing 
;

Script FHPRouting()
	FHPBrailleUnhideBrailleCursor()
	PerformScript BrailleRouting()
EndScript

;
; Attribute handling
;

Script FHPBrailleTurnMarkingOff()
	var int CurrentAttribute

	FHPBrailleUnhideBrailleCursor()

	let CurrentAttribute = GetJcfOption(OPTBRL_MARKING)

	if (CurrentAttribute != BRL_MARKING_NONE) then
		SetJcfOption(OPTBRL_MARKING, BRL_MARKING_NONE)
		Say (msg392, OT_STRING)  ; braille marking none
	else 	
		SetJcfOption(OPTBRL_MARKING, BRL_MARKING_ALL)
		Say (msg398, OT_STRING)  ; braille marking all
	endif
EndScript


Script FHPBrailleShowBoldMarking()
	FHPBrailleUnhideBrailleCursor()
	SetJcfOption(OPTBRL_MARKING, BRL_MARKING_BOLD)
	Say (msg394, OT_STRING)  ; braille marking bold
EndScript


Script FHPBrailleShowHighlightMarking()
	FHPBrailleUnhideBrailleCursor()
	SetJcfOption(OPTBRL_MARKING, BRL_MARKING_HIGHLIGHT)
	Say (msg393, OT_STRING)  ; braille marking highlight
EndScript


Script FHPBrailleShowItalicMarking()
	FHPBrailleUnhideBrailleCursor()
	SetJcfOption(OPTBRL_MARKING, BRL_MARKING_ITALIC)
	Say (msg396, OT_STRING)  ; braille marking italic
EndScript


Script FHPBrailleShowUnderlineMarking()
	FHPBrailleUnhideBrailleCursor()
	SetJcfOption(OPTBRL_MARKING, BRL_MARKING_UNDERLINE)
	Say (msg395, OT_STRING)  ; braille marking underline
EndScript


Script FHPBrailleShowAllMarking ()
	FHPBrailleUnhideBrailleCursor()
	SetJcfOption(OPTBRL_MARKING, BRL_MARKING_ALL)
	Say (msg398, OT_STRING)  ; braille marking all
EndScript


Script FHPBrailleToggleCharactersAndAttributes ()
	FHPBrailleUnhideBrailleCursor()
	PerformScript BrailleToggleCharactersAndAttributes()
EndScript

Script FHPBrailleToggleAttributeUp ()

	FHPBrailleUnhideBrailleCursor()
	FHPBrailleNameAttribute(FHPBrailleToggleAttribute(0))

EndScript


Script FHPBrailleToggleAttributeDown ()

	FHPBrailleUnhideBrailleCursor()
	FHPBrailleNameAttribute(FHPBrailleToggleAttribute(1))

EndScript


Int Function FHPBrailleToggleAttribute (int direction)
	var int CurrentAttribute

	let CurrentAttribute = GetJcfOption(OPTBRL_MARKING)

	if (direction == 0) then
		; cycle forward
		if (CurrentAttribute >= BRL_MARKING_ALL) then
			let CurrentAttribute = BRL_MARKING_NONE
		else
			let CurrentAttribute = CurrentAttribute+1
		endif
	else
		;  cycle backward
		if (CurrentAttribute <= BRL_MARKING_NONE) then
			let CurrentAttribute = BRL_MARKING_ALL
		else
			let CurrentAttribute = CurrentAttribute-1
		endif
	endif

	SetJcfOption(OPTBRL_MARKING, CurrentAttribute)
	return CurrentAttribute

EndFunction


void Function FHPBrailleNameAttribute(int attribute)
	if (attribute == BRL_MARKING_NONE) then
		Say (msg392, OT_STRING) ;"Braille marking off"
		return
	endif
	if (attribute == BRL_MARKING_HIGHLIGHT) then
		Say (msg393, OT_STRING) ;"Braille marking  highlight"
		return
	endif
	if (attribute == BRL_MARKING_BOLD) then
		Say (msg394, OT_STRING)  ;"Braille marking  bold"
		return
	endif
	if (attribute == BRL_MARKING_UNDERLINE) then
		Say (msg395, OT_STRING) ; "Braille marking  underline"
		return
	endif
	if (attribute == BRL_MARKING_ITALIC) then
		Say (msg396, OT_STRING) ; "Braille marking  italic"
		return
	endif
	if (attribute == BRL_MARKING_STRIKEOUT) then
		Say (msg397, OT_STRING) ; "Braille marking  strike out"
		return
	endif
	if (attribute == BRL_MARKING_ALL) then 
		Say (msg398, OT_STRING) ; "Braille marking all "
		return
	endif
EndFunction

;
; END attribute handling
;

Script FHPBrailleShowWindowsTop ()

	FHPBrailleUnhideBrailleCursor()

	if (GetJCFOption (OPT_BRL_MOVE_ACTIVE_CURSOR)==1)  then
     		if  (IsPCCursor()) then
        			Beep()
     		else
         			JawsPageUp ()
     		endif
	else
		SaveCursor()
		Braillecursor ()
		JawsPageUp()
		SayLine()
		RestoreCursor ()
	endif
EndScript


Script FHPBrailleShowWindowsBottom ()

	FHPBrailleUnhideBrailleCursor()

	if (GetJcfOption (OPT_BRL_MOVE_ACTIVE_CURSOR)==1)  then
     		if  (IsPCCursor()) then
         			Beep()
		else
         			JawsPageDown ()
     		endif
	else
		SaveCursor()
		Braillecursor ()
		JawsPageDown()
		SayLine()
		RestoreCursor ()
	endif
EndScript



Script FHPBrailleToggle68Dots ()
	FHPBrailleUnhideBrailleCursor()
	PerformScript  BrailleToggle8Dots()
EndScript


Script FHPToggleCursorMode ()

	FHPBrailleUnhideBrailleCursor()

	if (IsPCCursor()) then
		PerformScript JawsCursor()
	else
		PerformScript PCCursor()
	endif

EndScript


Script FHPBrailleToggleCursorShape ()
	Var String CursorDots

	Let CursorDots = BrailleGetCursorDots()
	
	if (CursorDots == msgNull) then
		BrailleSetCursorDots (OldCursorDots)
		Let g_bBrailleCursorHidden = 0
	else
		Let OldCursorDots = CursorDots
		Let g_bBrailleCursorHidden = 1
		BrailleSetCursorDots (msgNull)
	EndIf

EndScript


Void Function FHPBrailleUnhideBrailleCursor ()

	if (g_bBrailleCursorHidden == 1) then
		PerformScript FHPBrailleToggleCursorShape()
	endif

EndFunction


Script FHPBrailleActiveCursorTracking ()
	var int ActiveCursor

	FHPBrailleUnhideBrailleCursor()

	let activeCursor = GetActiveCursor()
	if (ActiveCursor == cursor_jaws) then
		RouteBrailleToJaws ()
	ElIf (ActiveCursor == cursor_pc) then
		RouteBrailleToPC ()
	EndIf

EndScript



Script FHPBrailleSelectText ()
	FHPBrailleUnhideBrailleCursor()
	PerformScript BrailleSelectText()
EndScript

;*******
; Keyboard Help section
globals
	int nKeyboardHelpSavedTypingEcho

Script KeyboardHelp()
Say (msg401, ot_message) ; "Keyboard Help on"
let nKeyboardHelpSavedTypingEcho = GetJCFOption(OPT_TYPING_ECHO)
SetJcfOption(OPT_TYPING_ECHO,1) ; echo characters
AddHook (HK_SCRIPT, "KeyboardHelpHook")
; ignore any keys not attached to scripts
TrapKeys(TRUE)
EndScript

Void Function KeyboardHelpHook (string ScriptName, string FrameName)
if (ScriptName == "KeyboardHelp") then
	Say (msg402, ot_message) ; "Keyboard Help off"
	RemoveHook (HK_SCRIPT, "KeyboardHelpHook")
	TrapKeys(FALSE)
	SetJcfOption(OPT_TYPING_ECHO,nKeyboardHelpSavedTypingEcho)
	return FALSE
EndIf
if IsSameScript () then
	if ((FrameName != msgNull) && (GetFrameDescription (FrameName) != msgNull)) then
		Say (msg420, ot_help) ; "This frame "
		Say (GetFrameDescription (FrameName), ot_help)
	EndIf
	if (FrameName == msgNull) then
		Say (GetScriptDescription(ScriptName), ot_help)
	EndIf
else
	Say (GetCurrentScriptKeyName (), ot_help) ; says key name, "insert+up arrow"
	if (FrameName != msgNull) then
		Say (msg421 + FrameName, ot_help) ; "says the content of the frame "
		Say (GetFrameSynopsis (FrameName), ot_help)
	else
		Say (ScriptName, ot_help) ; will say the name of the script, "SayLine"
		Say (GetScriptSynopsis(ScriptName), ot_help)
	EndIf
EndIf
; by returning  FALSE, a hook function can prevent a script from being run
return FALSE
EndFunction

Int Function RoutePCToInvisible ()
var   int Row,   int Column,   int nSuccess
InvisibleCursor()
let Row = GetCursorRow ()
let Column = GetCursorCol ()
PCCursor()
let nSuccess = MoveTo (Column, Row)
return nSuccess
EndFunction

Script SayAppVersion ()
Say (GetVersionInfoString (GetAppFilePath (), msg557)+
		msg506 + GetVersionInfoString (GetAppFilePath (), msg558),ot_app_information)
EndScript

Script SayProgramComments ()
Say (GetVersionInfoString (GetAppFilePath (), msg559), ot_app_information)
EndScript

Void Function RestrictCursor (int nStatus)
if (ToggleRestriction () != nStatus) then
	ToggleRestriction ()
endif
EndFunction

Script SayTaskBar ()
var
handle hWnd
let hWnd = FindTopLevelWindow (wcShellTray, msgNull)
let hWnd = GetFirstChild(hWnd)
if (hWnd) then
	while (hWnd && GetWindowClass (hWnd) != wcMSTask)
  if GetWindowClass (hWnd) == wcRebarWnd then ; Win_98
   let hWnd = GetFirstChild(hWnd)
  else
   let hWnd = GetNextWindow(hWnd)
  endif
	EndWhile

	let hWnd = GetFirstChild(hWnd)
	while (hWnd && GetWindowClass (hWnd) != wcSysTabCtrl32)
		let hWnd = GetNextWindow(hWnd)
	EndWhile

	if (GetWindowClass(hWnd) == wcSysTabCtrl32 && !IsWindowObscured (hWnd))
then
		SayWindow(hWnd, READ_EVERYTHING)
		return
	endif
endif
Say (msg442, OT_STRING) ; "Task bar is not visible"
EndScript


Script SaySystemTray ()
var
handle hWnd
let hWnd = FindTopLevelWindow (wcShellTray, msgNull)
let hWnd = FindDescendantWindow (hWnd, 303)
if (hWnd) then
	SayWindow(hWnd, READ_EVERYTHING)
else
	Say (msg443, ot_message) ; "system tray is not visible"
endif
EndScript

Script FormatAndText ()
if GetJCFOption (OPT_FORMAT_AND_TEXT) == 1 then
	SetDefaultJcfOption (OPT_FORMAT_AND_TEXT, 0)
	Say (msg518, ot_message)
else
	SetDefaultJcfOption (OPT_FORMAT_AND_TEXT, 1)
	Say (msg519, ot_message)
EndIf
EndScript

Script AttributesChanges ()
if GetJCFOption (OPT_FORMAT_ATTRIBUTES) == 1 then
	SetDefaultJcfOption (OPT_FORMAT_ATTRIBUTES, 0)
	Say (msg518, ot_message)
else
	SetDefaultJcfOption (OPT_FORMAT_ATTRIBUTES, 1)
	Say (msg519, ot_message)
EndIf
EndScript

Script FontChanges ()
if GetJCFOption (OPT_FORMAT_FONT) == 1 then
	SetDefaultJcfOption (OPT_FORMAT_FONT, 0)
	Say (msg518, ot_message)
else
	SetDefaultJcfOption (OPT_FORMAT_FONT, 1)
	Say (msg519, ot_message)
EndIf
EndScript

Script PointSizeChanges ()
if GetJCFOption (OPT_FORMAT_POINTSIZE) == 1 then
	SetDefaultJcfOption (OPT_FORMAT_POINTSIZE, 0)
	Say (msg518, ot_message)
else
	SetDefaultJcfOption (OPT_FORMAT_POINTSIZE, 1)
	Say (msg519, ot_message)
EndIf
EndScript

Script TextColorChanges ()
if GetJCFOption (OPT_FORMAT_TEXTCOLOR) == 1 then
	SetDefaultJcfOption (OPT_FORMAT_TEXTCOLOR, 0)
	Say (msg518, ot_message)
else
	SetDefaultJcfOption (OPT_FORMAT_TEXTCOLOR, 1)
	Say (msg519, ot_message)
EndIf
EndScript

Script BackgroundColorChanges ()
if GetJCFOption (OPT_FORMAT_BACKGROUNDCOLOR) == 1 then
	SetDefaultJcfOption (OPT_FORMAT_BACKGROUNDCOLOR, 0)
	Say (msg519, ot_message)
else
	SetDefaultJcfOption (OPT_FORMAT_BACKGROUNDCOLOR, 1)
	Say (msg518, ot_message)
EndIf
EndScript

String Function IntToAttribName (int attrib)
if (attrib == attrib_bold) then
	return msg366 ;"Bold"
EndIf
if (attrib == attrib_italic) then
	return msg367 ;"Italic"
EndIf
if (attrib == attrib_underline) then
	return msg368 ;"Underline"
EndIf
if (attrib == attrib_highlight) then
	return msg369 ;"Highlight"
EndIf
if (attrib == attrib_strikeout) then
	return msg370 ;"Strikeout"
EndIf
if (attrib == attrib_graphic) then
	return msg370a ;"Graphic"
EndIf
return msgNull
EndFunction

Void Function SayFormatAndText (string buffer, ; text to be spoken
	int attributes, ; attributes for this segment of text
	int attributesFound, ; attributes present in previous segments of text since the last normal text
	string fontName, ; name of the font of this segment of text
	int points, ; point size of this segment of text
	int textColor, int backgroundColor, ; colors of the segment
	int repetitions, ; number of times this segment is repeated
	int capType, ; type of capitalization present on this segment, it can be
;				one of the CAPITALIZATION_ constants define in hjconst
	int indentation, ; when reading by lines indicates the number of pixels between
;				the left edge of the window and the first character in the line
	int outputType, ; indicates the type of reading operation that is being performed,
;				it can be one of the OT_ constants defined in hjconst
	int formatDifferences) ; indicates which aspects of the format information have changed from the previous segment.
if formatDifferences & FORMAT_FIRSTSEGMENT then
if globalSayingCurrentItem then ; speaks all the formatting that is turned on
	let formatDifferences = FORMAT_ALL
EndIf
EndIf
if outputType == OT_LINE then
if formatDifferences & FORMAT_INDENTATION then
	if GetJCFOption (OPT_FORMAT_INDENTATION) == 1 then
		if indentation >= 0 then
			SayUsingVoice (VCTX_MESSAGE, IntToString(indentation) + msg548, OT_STRING)
		EndIf
	EndIf
EndIf
EndIf
if formatDifferences & FORMAT_ATTRIBS then
if GetJCFOption (OPT_FORMAT_ATTRIBUTES) == 1 then
	AttributesChanged (attributes, attributesFound)
EndIf
EndIf
if attributes > 0 && !(attributes & ATTRIB_GRAPHIC) then
; this is text
	if formatDifferences & FORMAT_FONT then
		if GetJCFOption (OPT_FORMAT_FONT) == 1 then
			SayUsingVoice (VCTX_MESSAGE, fontName, OT_STRING)
		EndIf
	EndIf
	if formatDifferences & FORMAT_POINTS then
	if GetJCFOption (OPT_FORMAT_POINTSIZE) == 1 then
		SayUsingVoice (VCTX_MESSAGE, IntToString (points) + msg512, OT_STRING) ;" point"
	EndIf
	EndIf
	if formatDifferences & FORMAT_TEXTCOLOR then
	if GetJCFOption (OPT_FORMAT_TEXTCOLOR) == 1 then
		SayUsingVoice (VCTX_MESSAGE, GetColorName (textColor), OT_STRING)
	EndIf
	EndIf
	if formatDifferences & FORMAT_BACKGROUNDCOLOR then
	if GetJCFOption (OPT_FORMAT_BACKGROUNDCOLOR) == 1 then
		SayUsingVoice (VCTX_MESSAGE, GetColorName (backgroundColor), OT_STRING)
	EndIf
	EndIf
EndIf
if GetJCFOption (OPT_FORMAT_REPETITIONS) == 1 then
	if ProcessRepetitions (buffer, repetitions, outputType, formatDifferences) then
		return
	EndIf
EndIf
if GetJCFOption (OPT_FORMAT_CAPITALIZATION) == 1 then
	if capType == CAPITALIZATION_CAP then
		SayUsingVoice (VCTX_MESSAGE, msg513, OT_STRING) ;"cap "
	elif capType == CAPITALIZATION_ALLCAPS THEN
		SayUsingVoice (VCTX_MESSAGE, msg514, OT_STRING) ;"all caps "
	EndIf
EndIf
;ResetSynth ()
if outputType == OT_LINE then
	Say (buffer, OT_STRING)
else
	Say (buffer, outputType)
EndIf
EndFunction

Void Function AttributesChanged (int attributes, int attributesFound)
var
	int attrib
if attributes == 1 then ; this is normal text
	if attributesFound >= ATTRIB_BOLD then
		SayUsingVoice (VCTX_MESSAGE, msg511, OT_STRING) ;" Normal "
	EndIf
	return
EndIf
let attrib = attrib_bold
while (attrib <= attrib_highlight)
	if attributes & attrib then
		SayUsingVoice (VCTX_MESSAGE, IntToAttribName (attrib), OT_STRING)
	EndIf
	let attrib = attrib * 2
EndWhile
EndFunction

int Function ProcessRepetitions (string buffer, int repetitions, int outputType, int formatDifferences)
if repetitions > 1 then
	SayUsingVoice (VCTX_MESSAGE, IntToString (repetitions)+" ", OT_STRING)
	Say(buffer, OT_CHAR)
	return 1
EndIf
return 0
EndFunction

Script SayTextAndAttributes ()
var
	int x,
	int y,
	handle WinHandle,
	int prevAttrib,
	int curAttrib
let WinHandle = GetFocus ()
SaveCursor ()
InvisibleCursor ()
MoveToWindow (WinHandle)
if !ToggleRestriction () then
	ToggleRestriction ()
EndIf
let prevAttrib = 1
let curAttrib = GetCharacterAttributes ()
while ((x != GetCursorCol ()) || (y != GetCursorRow ()))
let x = GetCursorCol ()
let y = GetCursorRow ()
SayAttributesChanges (prevAttrib, curAttrib)
SayField ()
NextChunk ()
let prevAttrib = curAttrib
let curAttrib = GetCharacterAttributes ()
EndWhile
if ToggleRestriction () then
	ToggleRestriction ()
EndIf
RestoreCursor ()
EndScript

Void Function SayAttributesChanges (int prevAttrib, int curAttrib)
var
	int attrib
let attrib = attrib_bold
while (attrib <= attrib_highlight)
if ((prevAttrib & attrib) != (curAttrib & attrib)) then
	if (curAttrib & attrib) then
		Say (IntToAttribName (attrib) + msg507, ot_font)
	else
		Say (IntToAttribName (attrib) + msg508, ot_font)
	EndIf
EndIf
let attrib = attrib * 2
EndWhile
EndFunction

Function MouseMovedEvent (int x, int y)
; Add your code for KeyPressedEvent here.
; Changes made here apply to all applications.
; To make your changes application specific, copy this function to an
; application script file.
EndFunction

Int Function GetWordWidth ()
var
int nLength,
int nPixels,
int nSafety

let nSafety = 0
let nPixels = 0

let nLength = StringLength (GetWord())
if (nLength == 0) then return  0 endif

SaveCursor()
InvisibleCursor()
RouteInvisibleToPc ()
while (nSafety < nLength)
	let nPixels = nPixels + GetCharacterWidth()
	if (IsWordDelimiter(GetCharacter())) then return nPixels endif
	NextCharacter()
	let nSafety = nSafety + 1
endwhile
return nPixels
EndFunction

Int Function IsWordDelimiter (string strChar)
if (StringLength(strChar) > 1) then
	return 0
endif

return (StringContains (WORD_DELIMITERS, strChar) != 0)

EndFunction

Int Function GetBrailleMode ()
return GetJCFOption(OPT_BRL_MODE)
EndFunction

Void Function SetBrailleMode (int nMode)
SetDefaultJcfOption(OPT_BRL_MODE,nMode)
EndFunction

; ***
; Run Manager section
; ***

Script WindowClassReassign ()
var
	string TheApp,
	string TheClass,
	string RunIt
Let TheApp = GetAppFileName ()
Let TheClass = GetWindowClass (GetCurrentWindow())
;wn95="Invalid Window Handle"
If (TheClass == wn95) then
	;wn96="Invalid"
	Let TheClass = wn96
EndIf
;RunIt = JConfig.exe -a[Application] + -c[Class Name] + d[Dialog mode]
Let RunIt = MGR_CONFIG + " " + FLAG_APP + "\"" + TheApp + "\" " + FLAG_CLASS + "\"" + TheClass + "\"" + " " + FLAG_CLASS_MODE
RunManager (RunIt)
EndScript

Script ConfigManager ()
var
	string TheApp,
	string TheClass,
	string RunIt
Let TheApp = GetAppFileName ()
Let TheClass = GetWindowClass (GetCurrentWindow())
;wn95="Invalid Window Handle"
If (TheClass == wn95) then
	;wn96="Invalid"
	Let TheClass = wn96
EndIf
;RunIt = JConfig.exe -a[Application] + -c[Class Name]
Let RunIt = MGR_CONFIG + " " + FLAG_APP + "\"" + TheApp + "\"" + " " + FLAG_CLASS + "\"" + TheClass + "\""
RunManager (RunIt)
EndScript

String Function CreateDictionaryCommandLine (int bDoAddDialog)
var
	string theword,
	int HighlightFound,
	string TheApp,
	string Runit,
	int Period,
	HANDLE CurrentWindow
let theword = GetWord()
Let TheApp = GetAppFileName ()
Let Period = StringContains (TheApp, ".")
Let TheApp = SubString (TheApp, 1, Period-1)
Let CurrentWindow = GetCurrentWindow()
if (GetCharacterAttributes() & ATTRIB_GRAPHIC) then
	Say (msg428, ot_message) ; "Use the Graphics Labeler to label graphics"
	return msgNull
endif
;See if there is highlighted text
if (IsPCCursor()) then
	SaveCursor()
	InvisibleCursor ()
	RouteInvisibleToPc ()
	if (GetCharacterAttributes () & ATTRIB_HIGHLIGHT) then
		let theWord = "\""+GetField()+"\""
	else
		PriorCharacter ()
		if (GetCharacterAttributes () & ATTRIB_HIGHLIGHT) then
			let theWord = "\""+GetField()+"\""
		endif
	Endif
	RestoreCursor()
endif
if (theword != msgNull) then
	;RunIt = "JDiction.exe -a[Application] -r[Rule]
	Let Runit = MGR_DICTION + "  " + FLAG_APP + "\"" + TheApp + "\"  " +  FLAG_RULE + theword
	if (bDoAddDialog == TRUE) then
		Let Runit = Runit + " -d"
	endif
else
	;RunIt = "JDiction.exe -a[Application]
	Let Runit = MGR_DICTION + "  " + FLAG_APP + "\"" + TheApp + "\""
	if (bDoAddDialog == TRUE) then
		Let Runit = Runit + " -d"
	endif
endif
return RunIt
EndFunction

Script DictionaryManager ()
var String RunIt
;Start dictionary Manager
let RunIt = CreateDictionaryCommandLine (FALSE)
if (RunIt != msgNull) then
	RunManager (RunIt)
EndIf
EndScript

Void Function FrameClearValues ()
let GlobalFrameTopLeft = msgNull
let GlobalFrameBottomRight = msgNull
EndFunction

Script FrameGetTopLeft ()
var
	int X,
	int Y

if (IsSameScript ()) then
	FrameSetOnWindow (GetCurrentWindow())
else
	;JAWSCursor ()
	let X = GetCursorCol ()
	let Y = GetLineTop ()
	if (!Y) then
		let Y = GetCursorRow()
	endif
	;  format Top Left Dimensions to a string
	Let GlobalFrameTopLeft = IntToString (X) + "," + IntToString (Y)
	if (GetVerbosity () == BEGINNER) then
		Say (msg435, ot_message) ; "Setting Frame top left corner "
	endif
endif
SetParentDims()
if (GlobalFrameBottomRight != msgNull) then
	FrameManagerRun()
	; reset GlobalVariables
	let GlobalFrameTopLeft = msgNull
	let GlobalFrameBottomRight = msgNull
endif
EndScript

Script FrameGetBottomRight ()
var
	int X,
	int Y

;JAWSCursor ()
let X = GetCursorCol () + GetCharacterWidth ()
let Y = GetCursorRow ()
;  format Top Left Dimensions to a string
Let GlobalFrameBottomRight = IntToString (X) + "," + IntToString (Y)
if (GetVerbosity () == BEGINNER) then
	Say (msg436, ot_message) ; "Setting Frame bottom right corner "
endif
SetParentDims()
if (GlobalFrameTopLeft != msgNull) then
	FrameManagerRun()
	; reset GlobalVariables
	let GlobalFrameTopLeft = msgNull
	let GlobalFrameBottomRight = msgNull
endif
EndScript

Void Function FrameSetOnWindow (handle CurrentWindow)
var
int WindowTop,
int WindowLeft,
int WindowBottom,
int WindowRight

if (!CurrentWindow) then
	let CurrentWindow = GetCurrentWindow()
endif

let WindowTop = GetWindowTop (CurrentWindow)
let WindowLeft = GetWindowLeft (CurrentWindow)
let WindowBottom = GetWindowBottom (CurrentWindow)
let WindowRight = GetWindowRight (CurrentWindow)

Let GlobalFrameTopLeft = IntToString (WindowLeft) + "," + IntToString (WindowTop)
Let GlobalFrameBottomRight = IntToString (WindowRight) + "," + IntToString (WindowBottom)
EndFunction

Void Function FrameManagerRun ()
var
	HANDLE hRealWindow,
	string sRealName,
	string sClass,
	string sID,
	string sApp,
	int nPeriod,
	string RunIt
if ((GlobalFrameTopLeft == msgNull) || (GlobalFrameBottomRight == msgNull)) then
	return
endif
let hRealWindow = GetTopLevelWindow (GetCurrentWindow())
let sRealName = GetWindowName(hRealWindow)
let sClass = GetWindowClass(hRealWindow)
let sID = IntToString(GetControlID(hRealWindow))
let sApp = GetAppFileName ()
let nPeriod = StringContains (sApp, ".")
let sApp = SubString (sApp, 1, nPeriod-1)
let RunIt = MGR_FRAME
let RunIt = RunIt + " "
let RunIt = RunIt + FLAG_APP + "\"" + sApp + "\""
let RunIt = RunIt + " -n\"" + sRealName
let RunIt = RunIt + "\""
let RunIt = RunIt + " -i" + sID
let RunIt = RunIt + " -c\"" + sClass
let RunIt = RunIt + "\""
let RunIt = RunIt + " -p" + GlobalFrameParentDims
let RunIt = RunIt + " -f" + GlobalFrameTopLeft + "," + GlobalFrameBottomRight
;MessageBox(RunIt)
PcCursor ()
RunManager(RunIt)
EndFunction

Function SetParentDims ()
var
	string sTLX,
	string sTLY,
	string sBRX,
	string sBRY,
	HANDLE hRealWindow,
	string TempString
let hRealWindow = GetTopLevelWindow (GetCurrentWindow ())
let sTLX = IntToString (GetWindowLeft (hRealWindow))
let sTLY = IntToString (GetWindowTop (hRealWindow))
let sBRX = IntToString (GetWindowRight (hRealWindow))
let sBRY = IntToString (GetWindowBottom (hRealWindow))
let GlobalFrameParentDims = sTLX + "," + sTLY + "," + sBRX + "," + sBRY
EndFunction

Script FrameManager ()
var
	string TheApp,
	string Runit,
	int Period,
	HANDLE CurrentWindow
Let TheApp = GetAppFileName ()
Let Period = StringContains (TheApp, ".")
Let TheApp = SubString (TheApp, 1, Period-1)
Let CurrentWindow = GetCurrentWindow()
;RunIt = "JFrame.exe -a[Application]
Let Runit = MGR_FRAME + "  " + FLAG_APP + "\"" + TheApp + "\""
RunManager (RunIt)
EndScript

Script KeyboardManager ()
var
	string TheApp,
	string Runit,
	int Period,
	HANDLE CurrentWindow
Let TheApp = GetAppFileName ()
Let Period = StringContains (TheApp, ".")
Let TheApp = SubString (TheApp, 1, Period-1)
Let CurrentWindow = GetCurrentWindow()
Let Runit = "jkey.exe" + "  " + "\"" + TheApp + "\""
RunManager (Runit)
EndScript

Script ScriptManager ()
var
 string TheApp,
 string Runit,
 int Period,
 HANDLE CurrentWindow
let TheApp = GetScriptFileName(TRUE)
if (!TheApp) then
	Let TheApp = GetAppFileName ()
Endif
Let Period = StringContains (TheApp, ".")
Let TheApp = SubString (TheApp, 1, Period-1)
Let CurrentWindow = GetCurrentWindow()
Let Runit = MGR_SCRIPT + "  " + "\"" + TheApp + "\""
RunManager (Runit)
EndScript

Script  ScriptManagerDefault()
RunManager ("jscript.exe default.jss")
EndScript

Function RunManager (string strCommandLine)
var
	String RunIt
let RunIt = GetJawsDirectory () + "\\" + strCommandLine
Run(RunIt)
;MessageBox(RunIt)
EndFunction

Script RunJAWSManager ()
var
	string managersList,
	int index
let managersList = ConfigManItem +
	WindowClassItem +
	DictionManItem +
	FrameManItem +
	KeyManItem +
	ScriptManItem+
	GraphicsLabelerItem;
let index = DlgSelectItemInList (ManagersList, RunManagerDialogTitle, TRUE);
pause ();
if (index == 1) then
	PerformScript ConfigManager ();
elif (index == 2) then
	PerformScript WindowClassReassign ();
elif (index == 3) then
	PerformScript DictionaryManager ();
elif (index == 4) then
	PerformScript FrameManager ();
elif (index == 5) then
	PerformScript KeyboardManager ();
elif (index == 6) then
	PerformScript ScriptManager ();
elif (index == 7) then
	PerformScript GraphicsLabeler ();
EndIf
EndScript

; ***
; Window event functions
; ***
Void Function ForgroundWindowChanged (handle newWindow)
EndFunction

Void Function WindowCreatedEvent (handle hWindow, int nLeft, int nTop, int nRight, int nBottom)
; It is best to override this function in application specific script files.
; Any code placed here will be processed very frequently.
EndFunction

Function WindowDestroyedEvent (handle hWindow)
EndFunction

Function WindowMinMaxEvent (handle hWindow, int nMinMaxRest, int nShow)
EndFunction

Function WindowResizedEvent (handle hWindow, int nLeft, int nTop, int nRight, int nBottom)
EndFunction

;***
;	The following section contains scripts to control the JAWS verobosity
;***

Script VerbosityLevel ()
Var
	int Verbosity
VerbosityLevel ()
let Verbosity = GetVerbosity ()
if Verbosity == 0 then
	Say (msg14, ot_message) ;"Beginner level"
	Return
endif
if Verbosity == 1 then
	Say (msg15, ot_message) ;"Intermediate level"
	Return
endif
if Verbosity == 2 then
	Say (msg16, ot_message) ;"Advanced level"
	Return
endif
EndScript

Script BrailleVerbosity ()

if  GetJcfOption (OPT_BRL_verbosity)==0
then SetJcfOption (OPT_BRL_verbosity, 1)
Say (msg487, ot_message) ; "Braille Verbosity Intermediate"
elif  GetJcfOption (OPT_BRL_verbosity)==1
then SetJcfOption (OPT_BRL_verbosity, 2)
Say (msg488, ot_message) ; "Braille Verbosity Advanced"
elif  GetJcfOption (OPT_BRL_verbosity)==2
then SetJcfOption (OPT_BRL_verbosity, 0)
Say (msg489, ot_message) ; "Braille Verbosity Beginner"
endif
EndScript

Script ScreenEcho ()
ScreenEcho()
if GetScreenEcho() == 0 then
	say (msg17, ot_message) ;"none"
endif
if GetScreenEcho() == 1 then
	Say (msg18, ot_message) ;"highlighted"
endif
if GetScreenEcho() == 2 then
	Say (msg19, ot_message) ;"all"
endif
EndScript

Script AnsiCharsDecrement ()
var
	int SpeakAnsiChars
Let SpeakAnsiChars = GetJcfOption (OPT_SPEAK_ANSI_CHARS)
If (SpeakAnsiChars == 0) then
	If (SetJcfOption (OPT_SPEAK_ANSI_CHARS, 4 ) == WAS_SUCCESSFUL)  then
		Say (msg82, ot_message) ;"All Ansi"
	Else ; WAS_NOT_SUCCESSFUL
		Say (msg83, ot_message) ;"Was not able to set change the j c f option"
	EndIf
Else
	If (SetJcfOption (OPT_SPEAK_ANSI_CHARS, SpeakAnsiChars - 1 ) == WAS_SUCCESSFUL)  then
		If (SpeakAnsiChars - 1) == 0 then
			Say (msg84, ot_message) ;"No Ansi"
		EndIf
		If (SpeakAnsiChars - 1) == 1 then
			Say (msg85, ot_message) ;"Some Ansi"
		EndIf
		If (SpeakAnsiChars - 1) == 2 then
			Say (msg86, ot_message) ;"More Ansi"
		EndIf
		If (SpeakAnsiChars - 1) == 3 then
			Say (msg87, ot_message) ;"Most Ansi"
		EndIf
	Else ; WAS_NOT_SUCCESSFUL
		Say (msg83, ot_message) ;"Was not able to set change the j c f option"
	EndIf
EndIf ; SpeakAnsiChars == 0
EndScript

Script AnsiCharsIncrement ()
var
	int SpeakAnsiChars
Let SpeakAnsiChars = GetJcfOption (OPT_SPEAK_ANSI_CHARS)
If (SpeakAnsiChars == 4) then
	If (SetJcfOption (OPT_SPEAK_ANSI_CHARS, 0 ) == WAS_SUCCESSFUL)  then
		Say (msg84, ot_message) ;"No Ansi"
	Else ; WAS_NOT_SUCCESSFUL
		Say (msg83, ot_message) ;"Was not able to set change the j c f option"
	EndIf
Else
	If (SetJcfOption (OPT_SPEAK_ANSI_CHARS, SpeakAnsiChars + 1 ) == WAS_SUCCESSFUL)  then
		If (SpeakAnsiChars + 1) == 1 then
			Say (msg85, ot_message) ;"Some Ansi"
		EndIf
		If (SpeakAnsiChars + 1) == 2 then
			Say (msg86, ot_message) ;"More Ansi"
		EndIf
		If (SpeakAnsiChars + 1) == 3 then
			Say (msg87, ot_message) ;"Most Ansi"
		EndIf
		If (SpeakAnsiChars + 1) == 4 then
			Say (msg82, ot_message) ;"All Ansi"
		EndIf
	Else ; WAS_NOT_SUCCESSFUL
		Say (msg83, ot_message) ;"Was not able to set change the j c f option"
	EndIf
EndIf ; SpeakAnsiChars == 0
EndScript

Script TypingEcho ()
; Script by Donny Dunn and Dennis Godin that toggles Typing Echo
Var
	Int Typing_Echo
Let Typing_Echo=GetDefaultJCFOption (opt_typing_Echo)
If (Typing_Echo == 2) Then
	SetDefaultJcfOption (Opt_Typing_Echo, 0)
	Say (msg107, ot_message) ;"None"
Else
	If (Typing_Echo == 0) Then
		SetDefaultJcfOption (Opt_Typing_Echo, 1)
		Say (msg108, ot_message) ;"Characters"
	Else
		If (Typing_Echo == 1) Then
			SetDefaultJcfOption (Opt_Typing_Echo, 2)
			Say (msg109, ot_message) ;"Words"
		EndIf
	EndIf
EndIf
EndScript

Script GraphicsVerbosity ()
var
	int currentSetting
let currentSetting = GetDefaultJCFOption (OPT_INCLUDE_GRAPHICS)
If (currentSetting == 2) Then
	SetDefaultJcfOption (OPT_INCLUDE_GRAPHICS, 0)
	Say (MSG490, ot_message) ;"No graphics"
ElIf (currentSetting == 0) Then
	SetDefaultJcfOption (OPT_INCLUDE_GRAPHICS, 1)
	Say (msg491, ot_message) ; "Labeled"
ElIf (currentSetting == 1) Then
	SetDefaultJcfOption (OPT_INCLUDE_GRAPHICS, 2)
	Say (msg492, ot_message) ;"All graphics"
EndIf
EndScript

Script AdjustJAWSVerbosity ()
var   	string list
if (IsSpeechOff ()) then
	PerformScript MuteSynthesizer()
	return
endif
let list = VerbosityLevelItem +
	ScreenEchoItem +
	TypingEchoItem  +
	SayAllByItem +
PunctuationLevelItem+
FormatItem +
	GraphicsItem +
	AnsiCharsIncItem+
	BrailleVerbosityItem+

	MuteSynth
	DlgSelectScriptToRun (list, AdjustJawsVerbosityDialogName, false)
EndScript

Script PunctuationToggle ()
var
  int nOffSet,
  int nPunctuationLevel
  let nOffSet = 1
  let nPunctuationLevel = GetJCFOption (opt_punctuation)
If (nPunctuationLevel == 3) then
  SetJCFOption (opt_punctuation, 0)
Else
  SetJCFOption (opt_punctuation, nPunctuationLevel + nOffSet)
EndIf
If (nPunctuationLevel == 0) then
  Say (msg551, ot_message)
ElIf (nPunctuationLevel == 1) then
  Say (msg552, ot_message)
Elif (nPunctuationLevel == 2) then
  Say (msg553, ot_message)
ElIf (nPunctuationLevel == 3) then
  Say (msg17, ot_message)
EndIf
EndScript

Function SayExtendedHelpHotKey ()
Say (msg473, ot_help)
Say (GetWindowName (GetAppMainWindow (GetCurrentWindow ())), ot_help)
Say (msg474, ot_help)
EndFunction

String Function GetCorrespondingHelpFile (string strApp)
var
string strHelpFile,
int nPeriod

let nPeriod = StringContains (strApp, ".")
let strApp = SubString (strApp, 1, nPeriod)

let strHelpFile = GetJawsHelpDirectory ()
let strHelpFile = strHelpFile + "\\"
let strHelpFile = strHelpFile + strApp
let strHelpFile = strHelpFile + "hlp"
return strHelpFile
EndFunction

Function AppFileTopic ()
var
string strApp,
string strHelpFile

let strApp = GetAppFileName ()
let strApp = StringLower (strApp)
let strHelpFile = GetCorrespondingHelpFile (strApp)

StopSpeech ()

if (StringContains (strListOfAppsWithTopics, strApp)) then
	ShowHelpByName ("JFW", strApp)
elif (StringContains (strListOfAppsWithTopics2, strApp)) then
	ShowHelpByName ("JFW", strApp)
elif (FileExists (strHelpFile) && !(StringContains (strListOfExcludedApps, strApp))) then
	ShowHelpByName (strHelpFile, strApp)
else
	Say (msg453 + strApp, ot_message)
endif
EndFunction

Void Function AppWillNotSpeakEvent (string strApp)
Say (strApp + msg457, ot_message)
EndFunction

Script MuteSynthesizer ()
if (IsSpeechOff ()) then
	SpeechOn()
	Say (msg459, ot_message); "Mute Off"
else
	Say (msg458, ot_message); "Mute On"
	SpeechOff()
endif
EndScript

Script SayAllBy ()

if GetJcfOption (OPT_SAY_ALL_MODE)==0
then Say (MSG516, ot_message)
SetJcfOption (	OPT_SAY_ALL_MODE, 1)
elif GetJcfOption (OPT_SAY_ALL_MODE)==1
then Say (MSG517, ot_message)
SetJcfOption (	OPT_SAY_ALL_MODE, 2)
elif GetJcfOption (OPT_SAY_ALL_MODE)==2
then Say (MSG515, ot_message)
SetJcfOption (	OPT_SAY_ALL_MODE, 0)
endif
EndScript

Script ListTaskTrayIcons ()
var int  nItems , int nIdx, int nButton, string GraphicList
let nItems = SysTrayGetItemCount()
let nIdx = 1
while (nIdx <= nItems)
  let GraphicList = graphicList + "|" + SysTrayGetItemToolTip(nIdx)
  let nIdx = nIdx+1
EndWhile
let nButton =DlgSysTray(GraphicList,nIdx)
if  (nIdx > 0 && nButton > 7000) then
  SaveCursor()
  SysTrayMoveToItem(nIdx)
  if  (nButton == 7001) then
   RightMouseButton()
  elif(nButton == 7002) then
    LeftMouseButton()
  elif(nButton == 7003) then
    LeftMouseButton()
    LeftMouseButton()
  EndIf
EndIf
EndScript

void Function SayTreeViewLevel ()
If (GetTreeViewLevel() != PreviousTreeviewLevel) then
	if GetVerbosity()== beginner then
		Say (Msg500, OT_STRING) ; "level "
	endif
	SayInteger(GetTreeViewLevel ())
	let PreviousTreeViewLevel=GetTreeviewLevel()
EndIf
SayLine ()
EndFunction

Void Function TooltipEvent (handle hWnd, string strText)
	let strLastTooltip = strText
EndFunction


Int Function GetGraphicID ()
var 	int col, int row,
	int nSafety,
	int nGraphicID

SaveCursor()
if (GetActiveCursor () == CURSOR_PC) then
	JAWSCursor()
endif

let col = GetCursorCol ()
let row = GetCursorRow ()
let nGraphicID = GetGraphicID ()
let nSafety = 0

while (!nGraphicID && nSafety < 3)
	let col = col+2
	let row = row - 2
	let nSafety = nSafety + 1
	MoveTo (col, row)
	let nGraphicID = GetGraphicID()
endwhile

return nGraphicID
EndFunction


Int Function AutoLabelGraphics (handle HGrip)
var
	int bProcessTooltipEvent,
	int nIncludeGraphics,
	int nSafety,
	int nSearch,
	int nKeepSearching,
	string strLabel,
	int nGraphicID, int nInvGraphicID,
	int nCol, int nRow, int nPrevCol, int nPrevRow,
	int nCount

SaveCursor()
let bProcessTooltipEvent = GetJcfOption (OPT_PROCESSTOOLTIPEVENT)
let nIncludeGraphics = GetJcfOption(OPT_INCLUDE_GRAPHICS)
let nSearch = GRAPHIC_FIRST
let nKeepSearching = 100
let nCol = 0 let nRow = 0
let strLabel = msgNull
let nCount = 0

SetJcfOption (OPT_PROCESSTOOLTIPEVENT, TRUE)
SetJcfOption (OPT_INCLUDE_GRAPHICS, 2)

MoveToWindow(HGrip)
while (MoveToGraphic(nSearch) && nKeepSearching)
	;Since we position the graphics cursor on the bottom left of the graphic, we can assume
	;a graphic has already been found if nRow is greater than 0.  If we just moved the JAWS
	;cursor to a graphic other than the first, then we need to see if the JAWS cursor affected
	;the appearance of the graphic.  If it did, then move the invisible cursor to it and relabel.
	if (nRow) then
		InvisibleCursor()
		MoveTo (nCol, nRow)
		let nInvGraphicID = GetGraphicID()
		if (nInvGraphicID != nGraphicID && strLabel != msgNull) then ; Graphic is different
			if (StringContains (GetWord(), "graphic")) then
				SetGraphicLabel(nInvGraphicID, strLabel, TRUE)
				let nCount = nCount + 1
			endif
		endif
		JAWSCursor()
	endif

	; If MoveToGraphic left us in the same pixel position as we were, then the graphic
	; labeler is complete.  Reset OPT_PROCESSTOOLTIPEVENT and OPT_INCLUDE_GRAPHICS
	; and return to the calling script.
	if (nRow == nPrevRow && nCol == nPrevCol && nSearch == GRAPHIC_NEXT) then
		SetJcfOption (OPT_PROCESSTOOLTIPEVENT, bProcessTooltipEvent)
		SetJcfOption (OPT_INCLUDE_GRAPHICS, nIncludeGraphics)
		return nCount
	endif

	let nPrevRow = nRow let nPrevCol = nCol
	let nRow = GetCursorRow () let nCol = GetCursorCol ()
	;Only go through the labeling process if the graphic is not already labeled.
	;If the graphic label contains the word "graphic," then it is not already labeled.
	if (StringContains (GetWord(), "graphic")) then
		let nSafety = 0
		while(strLastTooltip == msgNull && nSafety <10)
			delay(1)
			let nSafety = nSafety + 1
		endwhile

		if (strLastTooltip != msgNull) then
			let strLabel = strLastTooltip
			let nGraphicID = GetGraphicID()
			if (nGraphicID) then
				if (GetControlAttributes() & CTRL_GRAYED) then
					let strLabel = strLabel + " grayed"
				endif
				SetGraphicLabel(nGraphicID, strLabel, TRUE)
				let nCount = nCount + 1
			endif
			let strLastTooltip = msgNull
		endif
	endif ;graphic already labeled?

	let nSearch = GRAPHIC_NEXT

	; if a key is pressed while AutoLabeling, then quit looping
	if (IsKeyWaiting ())  then
		let nKeepSearching = 0
	else
		let nKeepSearching = nKeepSearching - 1
	endif
endwhile

SetJcfOption (OPT_PROCESSTOOLTIPEVENT, bProcessTooltipEvent)
SetJcfOption (OPT_INCLUDE_GRAPHICS, nIncludeGraphics)
return nCount
EndFunction

Script AutoLabelGraphicsStart ()
var int nCount, handle Hwnd
  let Hwnd = GetRealWindow (GetFocus ())
;msg509 = "Starting auto graphip labeler"
Say (msg509, ot_message)
Refresh() delay(10)
let nCount = AutoLabelGraphics(Hwnd)
Refresh() delay(10)
let nCount = nCount + AutoLabelGraphics(Hwnd)
;msg510 = "Auto labeler finished"
Say (msg510, ot_message)
Say (IntToString (nCount) + " graphics were labeled", ot_message)
EndScript

Script SayPriorSentence ()
PriorSentence ()
delay(1)
SaySentence ()
EndScript


Script SayNextSentence ()
NextSentence ()
delay(1)
SaySentence ()
EndScript

Script SaySentence ()
SaySentence ()
EndScript

Script SayPriorParagraph ()
PriorParagraph ()
if ! SayParagraph()
then Say (msg549, OT_STRING)
Say (MSG550, OT_STRING)
endif
EndScript

Script SayParagraph ()
if ! SayParagraph()
then Say (msg549, OT_STRING)
Say (MSG550, OT_STRING)
endif
EndScript

Script SayNextParagraph ()
NextParagraph ()
if ! SayParagraph()
then Say (msg549, OT_STRING)
Say (MSG550, OT_STRING)
endif
EndScript

Script ControlBackSpace ()
InvisibleCursor ()
RouteInvisibleToPc ()
PriorWord ()
SayWord ()
PcCursor ()
{Control + Back Space}
EndScript

Script SaySystemTime ()
If (IsSameScript ()) then
 SayUsingVoice (	VCTX_MESSAGE, SysGetDate(), ot_string)
  return 
EndIf 
SayUsingVoice (	VCTX_MESSAGE, SysGetTime(), ot_string)
EndScript

Script Enter ()
SayCurrentScriptKeyLabel()
enterKey()
EndScript

Script MoveToNextNonLinkText ()
NextNonLink ()
delay(1)
sayline()
EndScript


Script VirtualPCCursorToggle ()
if GetVersionInfoString (GetWindowsSystemDirectory ()+"\\shdocvw.dll", "fileVersion")<5
then Say (msg591, ot_string) 
return
 endif
if GetJCFOption (	OPT_VIRTUAL_PC_CURSOR)==0
then SetJCFOption (	OPT_VIRTUAL_PC_CURSOR, 1)
Say (msg584, ot_string)
else
refresh()
  SetJCFOption (	OPT_VIRTUAL_PC_CURSOR, 0)
Say (msg585, ot_string)
endif
EndScript
